/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.http.TransportHttpClient;
import co.elastic.clients.transport.rest5_client.MultiBufferEntity;
import co.elastic.clients.transport.rest5_client.Rest5ClientOptions;
import co.elastic.clients.transport.rest5_client.low_level.Cancellable;
import co.elastic.clients.transport.rest5_client.low_level.Request;
import co.elastic.clients.transport.rest5_client.low_level.Response;
import co.elastic.clients.transport.rest5_client.low_level.ResponseListener;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.util.BinaryData;
import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeaderValueParser;

public class Rest5ClientHttpClient
implements TransportHttpClient {
    private static final ConcurrentHashMap<String, ContentType> ContentTypeCache = new ConcurrentHashMap();
    private final Rest5Client restClient;

    public Rest5ClientHttpClient(Rest5Client restClient) {
        this.restClient = restClient;
    }

    public Rest5Client restClient() {
        return this.restClient;
    }

    @Override
    public Rest5ClientOptions createOptions(@Nullable TransportOptions options) {
        return Rest5ClientOptions.of(options);
    }

    @Override
    public TransportHttpClient.Response performRequest(String endpointId, @Nullable TransportHttpClient.Node node, TransportHttpClient.Request request, TransportOptions options) throws IOException {
        Rest5ClientOptions rcOptions = Rest5ClientOptions.of(options);
        Request restRequest = this.createRestRequest(request, rcOptions);
        Response restResponse = this.restClient.performRequest(restRequest);
        return new RestResponse(restResponse);
    }

    @Override
    public CompletableFuture<TransportHttpClient.Response> performRequestAsync(String endpointId, @Nullable TransportHttpClient.Node node, TransportHttpClient.Request request, TransportOptions options) {
        Request restRequest;
        final RequestFuture<TransportHttpClient.Response> future = new RequestFuture<TransportHttpClient.Response>();
        try {
            Rest5ClientOptions rcOptions = Rest5ClientOptions.of(options);
            restRequest = this.createRestRequest(request, rcOptions);
        }
        catch (Throwable thr) {
            future.completeExceptionally(thr);
            return future;
        }
        future.cancellable = this.restClient.performRequestAsync(restRequest, new ResponseListener(){

            public void onSuccess(Response response) {
                future.complete(new RestResponse(response));
            }

            public void onFailure(Exception exception) {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    @Override
    public void close() throws IOException {
        this.restClient.close();
    }

    private Request createRestRequest(TransportHttpClient.Request request, Rest5ClientOptions options) {
        Request clientReq = new Request(request.method(), request.path());
        Iterable<ByteBuffer> body = request.body();
        Map<String, String> requestHeaders = request.headers();
        if (!requestHeaders.isEmpty()) {
            int headerCount = requestHeaders.size();
            if (body == null && headerCount != 3 || headerCount != 4) {
                if (options == null) {
                    options = Rest5ClientOptions.initialOptions();
                }
                Rest5ClientOptions.Builder builder = options.toBuilder();
                for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
                    builder.setHeader(header.getKey(), header.getValue());
                }
                for (Map.Entry<String, String> header : options.headers()) {
                    builder.setHeader(header.getKey(), header.getValue());
                }
                options = builder.build();
            }
        }
        if (options != null) {
            clientReq.setOptions(options.restClientRequestOptions());
        }
        clientReq.addParameters(request.queryParams());
        if (body != null) {
            ContentType ct = null;
            String ctStr = requestHeaders.get("Content-Type");
            if (ctStr != null) {
                ct = ContentTypeCache.computeIfAbsent(ctStr, ContentType::parse);
            }
            clientReq.setEntity((HttpEntity)new MultiBufferEntity(body, ct));
        }
        return clientReq;
    }

    static class RestResponse
    implements TransportHttpClient.Response {
        private final Response restResponse;

        RestResponse(Response restResponse) {
            this.restResponse = restResponse;
        }

        @Override
        public TransportHttpClient.Node node() {
            return new TransportHttpClient.Node(this.restResponse.getHost().toURI());
        }

        @Override
        public int statusCode() {
            return this.restResponse.getStatusCode();
        }

        @Override
        public String header(String name) {
            return this.restResponse.getHeader(name);
        }

        @Override
        public List<String> headers(String name) {
            Header[] headers = this.restResponse.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                if (!header.getName().equalsIgnoreCase(name)) continue;
                BasicHeaderValueParser elementParser = new BasicHeaderValueParser();
                final HeaderElement[] elements = elementParser.parseElements((CharSequence)header.getValue(), null);
                return new AbstractList<String>(){

                    @Override
                    public String get(int index) {
                        return elements[index].getValue();
                    }

                    @Override
                    public int size() {
                        return elements.length;
                    }
                };
            }
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public BinaryData body() throws IOException {
            HttpEntity entity = this.restResponse.getEntity();
            return entity == null ? null : new HttpEntityBinaryData(this.restResponse.getEntity());
        }

        @Nullable
        public Response originalResponse() {
            return this.restResponse;
        }

        @Override
        public void close() throws IOException {
            EntityUtils.consume((HttpEntity)this.restResponse.getEntity());
        }
    }

    private static class RequestFuture<T>
    extends CompletableFuture<T> {
        private volatile Cancellable cancellable;

        private RequestFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && this.cancellable != null) {
                this.cancellable.cancel();
            }
            return cancelled;
        }
    }

    private static class HttpEntityBinaryData
    implements BinaryData {
        private final HttpEntity entity;

        HttpEntityBinaryData(HttpEntity entity) {
            this.entity = entity;
        }

        @Override
        public String contentType() {
            String h = this.entity.getContentType();
            return h == null ? "application/octet-stream" : h;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.entity.writeTo(out);
        }

        @Override
        public ByteBuffer asByteBuffer() throws IOException {
            NoCopyByteArrayOutputStream out = new NoCopyByteArrayOutputStream();
            this.entity.writeTo((OutputStream)out);
            return out.asByteBuffer();
        }

        @Override
        public InputStream asInputStream() throws IOException {
            return this.entity.getContent();
        }

        @Override
        public boolean isRepeatable() {
            return this.entity.isRepeatable();
        }

        @Override
        public long size() {
            long len = this.entity.getContentLength();
            return len < 0L ? -1L : this.entity.getContentLength();
        }
    }
}

