/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SpanTermQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final String field;
    private final FieldValue value;
    public static final JsonpDeserializer<SpanTermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanTermQuery::setupSpanTermQueryDeserializer);

    private SpanTermQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static SpanTermQuery of(Function<Builder, ObjectBuilder<SpanTermQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanTerm;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanTerm;
    }

    public final String field() {
        return this.field;
    }

    public final FieldValue value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
        generator.writeEnd();
    }

    protected static void setupSpanTermQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, FieldValue._DESERIALIZER, "value", "term");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value", true);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanTermQuery> {
        private String field;
        private FieldValue value;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder value(FieldValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.value(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder value(String value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(long value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(double value) {
            this.value = FieldValue.of(value);
            return this;
        }

        public final Builder value(boolean value) {
            this.value = FieldValue.of(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanTermQuery build() {
            this._checkSingleUse();
            return new SpanTermQuery(this);
        }
    }
}

