/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonEnums;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.LazyDeserializer;
import co.elastic.clients.util.TriFunction;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public interface JsonpDeserializer<V> {
    public EnumSet<JsonParser.Event> nativeEvents();

    public EnumSet<JsonParser.Event> acceptedEvents();

    default public boolean accepts(JsonParser.Event event) {
        return this.acceptedEvents().contains(event);
    }

    default public V deserialize(JsonParser parser, JsonpMapper mapper) {
        JsonParser.Event event = parser.next();
        if (event == JsonParser.Event.VALUE_NULL && !this.accepts(JsonParser.Event.VALUE_NULL)) {
            return null;
        }
        JsonpUtils.ensureAccepts(this, parser, event);
        return this.deserialize(parser, mapper, event);
    }

    public V deserialize(JsonParser var1, JsonpMapper var2, JsonParser.Event var3);

    public static <T> JsonpDeserializer<T> of(final Type type) {
        return new JsonpDeserializerBase<T>(EnumSet.allOf(JsonParser.Event.class)){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper) {
                return mapper.deserialize(parser, type);
            }

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                return mapper.deserialize(parser, type, event);
            }
        };
    }

    public static <T> JsonpDeserializer<T> of(EnumSet<JsonParser.Event> acceptedEvents, final BiFunction<JsonParser, JsonpMapper, T> fn) {
        return new JsonpDeserializerBase<T>(acceptedEvents){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper) {
                return fn.apply(parser, mapper);
            }

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> JsonpDeserializer<T> of(EnumSet<JsonParser.Event> acceptedEvents, final TriFunction<JsonParser, JsonpMapper, JsonParser.Event, T> fn) {
        return new JsonpDeserializerBase<T>(acceptedEvents){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                return fn.apply(parser, mapper, event);
            }
        };
    }

    public static <T> JsonpDeserializer<T> lazy(Supplier<JsonpDeserializer<T>> ctor) {
        return new LazyDeserializer<T>(ctor);
    }

    public static <T> JsonpDeserializer<T> fixedValue(final T value) {
        return new JsonpDeserializerBase<T>(EnumSet.noneOf(JsonParser.Event.class)){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                return value;
            }
        };
    }

    public static <T> JsonpDeserializer<T> emptyObject(final T value) {
        return new JsonpDeserializerBase<T>(EnumSet.of(JsonParser.Event.START_OBJECT)){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                if (event == JsonParser.Event.VALUE_NULL) {
                    return null;
                }
                JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
                return value;
            }
        };
    }

    public static JsonpDeserializer<String> stringDeserializer() {
        return JsonpDeserializerBase.STRING;
    }

    public static JsonpDeserializer<Integer> integerDeserializer() {
        return JsonpDeserializerBase.INTEGER;
    }

    public static JsonpDeserializer<Boolean> booleanDeserializer() {
        return JsonpDeserializerBase.BOOLEAN;
    }

    public static JsonpDeserializer<Long> longDeserializer() {
        return JsonpDeserializerBase.LONG;
    }

    public static JsonpDeserializer<Float> floatDeserializer() {
        return JsonpDeserializerBase.FLOAT;
    }

    public static JsonpDeserializer<Double> doubleDeserializer() {
        return JsonpDeserializerBase.DOUBLE;
    }

    public static JsonpDeserializer<Double> doubleOrNullDeserializer(double defaultValue) {
        return new JsonpDeserializerBase.DoubleOrNullDeserializer(defaultValue);
    }

    public static JsonpDeserializer<Integer> intOrNullDeserializer(int defaultValue) {
        return new JsonpDeserializerBase.IntOrNullDeserializer(defaultValue);
    }

    public static JsonpDeserializer<Number> numberDeserializer() {
        return JsonpDeserializerBase.NUMBER;
    }

    public static JsonpDeserializer<JsonValue> jsonValueDeserializer() {
        return JsonpDeserializerBase.JSON_VALUE;
    }

    public static JsonpDeserializer<Void> voidDeserializer() {
        return JsonpDeserializerBase.VOID;
    }

    public static <T> JsonpDeserializer<List<T>> arrayDeserializer(JsonpDeserializer<T> itemDeserializer) {
        return new JsonpDeserializerBase.ArrayDeserializer<T>(itemDeserializer);
    }

    public static <T> JsonpDeserializer<Map<String, T>> stringMapDeserializer(JsonpDeserializer<T> itemDeserializer) {
        return new JsonpDeserializerBase.StringMapDeserializer<T>(itemDeserializer);
    }

    public static <T> JsonpDeserializer<Map<String, T>> stringArrayMapUnionDeserializer(JsonpDeserializer<T> itemDeserializer) {
        return new JsonpDeserializerBase.StringArrayMapUnionDeserializer<T>(itemDeserializer);
    }

    public static <K extends JsonEnum, V> JsonpDeserializer<Map<K, V>> enumMapDeserializer(JsonpDeserializer<K> keyDeserializer, JsonpDeserializer<V> valueDeserializer) {
        return new JsonpDeserializerBase.EnumMapDeserializer<K, V>(keyDeserializer, valueDeserializer);
    }

    public static <T extends JsonEnum> JsonpDeserializer<List<T>> pipeSeparatedDeserializer(JsonEnum.Deserializer<T> enumDeserializer) {
        return new JsonEnums.PipeSeparatedDeserializer<T>(enumDeserializer);
    }

    public static <T> JsonpDeserializer<T> jsonString(final JsonpDeserializer<T> valueDeserializer) {
        EnumSet<JsonParser.Event> acceptedEvents = EnumSet.copyOf(valueDeserializer.acceptedEvents());
        acceptedEvents.add(JsonParser.Event.VALUE_STRING);
        EnumSet<JsonParser.Event> nativeEvents = EnumSet.copyOf(valueDeserializer.nativeEvents());
        nativeEvents.add(JsonParser.Event.VALUE_STRING);
        return new JsonpDeserializerBase<T>(acceptedEvents, nativeEvents){

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                if (event == JsonParser.Event.VALUE_STRING) {
                    JsonParser stringParser = mapper.jsonProvider().createParser((Reader)new StringReader(parser.getString()));
                    return valueDeserializer.deserialize(stringParser, mapper);
                }
                return valueDeserializer.deserialize(parser, mapper, event);
            }
        };
    }
}

