/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.RemoteClusterPrivilege;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetBuiltinPrivilegesResponse
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<String> index;
    private final List<RemoteClusterPrivilege> remoteCluster;
    public static final JsonpDeserializer<GetBuiltinPrivilegesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetBuiltinPrivilegesResponse::setupGetBuiltinPrivilegesResponseDeserializer);

    private GetBuiltinPrivilegesResponse(Builder builder) {
        this.cluster = ApiTypeHelper.unmodifiableRequired(builder.cluster, (Object)this, "cluster");
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.remoteCluster = ApiTypeHelper.unmodifiable(builder.remoteCluster);
    }

    public static GetBuiltinPrivilegesResponse of(Function<Builder, ObjectBuilder<GetBuiltinPrivilegesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<String> index() {
        return this.index;
    }

    public final List<RemoteClusterPrivilege> remoteCluster() {
        return this.remoteCluster;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.index)) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (String string : this.index) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteCluster)) {
            generator.writeKey("remote_cluster");
            generator.writeStartArray();
            for (RemoteClusterPrivilege remoteClusterPrivilege : this.remoteCluster) {
                remoteClusterPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetBuiltinPrivilegesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index");
        op.add(Builder::remoteCluster, JsonpDeserializer.arrayDeserializer(RemoteClusterPrivilege._DESERIALIZER), "remote_cluster");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetBuiltinPrivilegesResponse> {
        private List<String> cluster;
        private List<String> index;
        @Nullable
        private List<RemoteClusterPrivilege> remoteCluster;

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder cluster(ClusterPrivilege value, ClusterPrivilege ... values) {
            this.cluster = Builder._listAdd(this.cluster, value.jsonValue(), (String[])Arrays.stream(values).map(ClusterPrivilege::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder remoteCluster(List<RemoteClusterPrivilege> list) {
            this.remoteCluster = Builder._listAddAll(this.remoteCluster, list);
            return this;
        }

        public final Builder remoteCluster(RemoteClusterPrivilege value, RemoteClusterPrivilege ... values) {
            this.remoteCluster = Builder._listAdd(this.remoteCluster, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetBuiltinPrivilegesResponse build() {
            this._checkSingleUse();
            return new GetBuiltinPrivilegesResponse(this);
        }
    }
}

