/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.get_data_lifecycle_stats.DataStreamStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetDataLifecycleStatsResponse
implements JsonpSerializable {
    private final int dataStreamCount;
    private final List<DataStreamStats> dataStreams;
    @Nullable
    private final Long lastRunDurationInMillis;
    @Nullable
    private final Long timeBetweenStartsInMillis;
    public static final JsonpDeserializer<GetDataLifecycleStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataLifecycleStatsResponse::setupGetDataLifecycleStatsResponseDeserializer);

    private GetDataLifecycleStatsResponse(Builder builder) {
        this.dataStreamCount = ApiTypeHelper.requireNonNull(builder.dataStreamCount, (Object)this, "dataStreamCount", 0);
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.lastRunDurationInMillis = builder.lastRunDurationInMillis;
        this.timeBetweenStartsInMillis = builder.timeBetweenStartsInMillis;
    }

    public static GetDataLifecycleStatsResponse of(Function<Builder, ObjectBuilder<GetDataLifecycleStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int dataStreamCount() {
        return this.dataStreamCount;
    }

    public final List<DataStreamStats> dataStreams() {
        return this.dataStreams;
    }

    @Nullable
    public final Long lastRunDurationInMillis() {
        return this.lastRunDurationInMillis;
    }

    @Nullable
    public final Long timeBetweenStartsInMillis() {
        return this.timeBetweenStartsInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("data_stream_count");
        generator.write(this.dataStreamCount);
        if (ApiTypeHelper.isDefined(this.dataStreams)) {
            generator.writeKey("data_streams");
            generator.writeStartArray();
            for (DataStreamStats item0 : this.dataStreams) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.lastRunDurationInMillis != null) {
            generator.writeKey("last_run_duration_in_millis");
            generator.write(this.lastRunDurationInMillis.longValue());
        }
        if (this.timeBetweenStartsInMillis != null) {
            generator.writeKey("time_between_starts_in_millis");
            generator.write(this.timeBetweenStartsInMillis.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetDataLifecycleStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataStreamCount, JsonpDeserializer.integerDeserializer(), "data_stream_count");
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(DataStreamStats._DESERIALIZER), "data_streams");
        op.add(Builder::lastRunDurationInMillis, JsonpDeserializer.longDeserializer(), "last_run_duration_in_millis");
        op.add(Builder::timeBetweenStartsInMillis, JsonpDeserializer.longDeserializer(), "time_between_starts_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetDataLifecycleStatsResponse> {
        private Integer dataStreamCount;
        private List<DataStreamStats> dataStreams;
        @Nullable
        private Long lastRunDurationInMillis;
        @Nullable
        private Long timeBetweenStartsInMillis;

        public final Builder dataStreamCount(int value) {
            this.dataStreamCount = value;
            return this;
        }

        public final Builder dataStreams(List<DataStreamStats> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        public final Builder dataStreams(DataStreamStats value, DataStreamStats ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        public final Builder dataStreams(Function<DataStreamStats.Builder, ObjectBuilder<DataStreamStats>> fn) {
            return this.dataStreams(fn.apply(new DataStreamStats.Builder()).build(), new DataStreamStats[0]);
        }

        public final Builder lastRunDurationInMillis(@Nullable Long value) {
            this.lastRunDurationInMillis = value;
            return this;
        }

        public final Builder timeBetweenStartsInMillis(@Nullable Long value) {
            this.timeBetweenStartsInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataLifecycleStatsResponse build() {
            this._checkSingleUse();
            return new GetDataLifecycleStatsResponse(this);
        }
    }
}

