/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level.sniffer;

import co.elastic.clients.transport.rest5_client.low_level.Node;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.sniffer.NodesSniffer;
import co.elastic.clients.transport.rest5_client.low_level.sniffer.SnifferBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sniffer
implements Closeable {
    private static final Log logger = LogFactory.getLog(Sniffer.class);
    private static final String SNIFFER_THREAD_NAME = "es_rest_client_sniffer";
    private final NodesSniffer nodesSniffer;
    private final Rest5Client restClient;
    private final long sniffIntervalMillis;
    private final long sniffAfterFailureDelayMillis;
    private final Scheduler scheduler;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile ScheduledTask nextScheduledTask;

    Sniffer(Rest5Client restClient, NodesSniffer nodesSniffer, long sniffInterval, long sniffAfterFailureDelay) {
        this(restClient, nodesSniffer, new DefaultScheduler(), sniffInterval, sniffAfterFailureDelay);
    }

    Sniffer(Rest5Client restClient, NodesSniffer nodesSniffer, Scheduler scheduler, long sniffInterval, long sniffAfterFailureDelay) {
        this.nodesSniffer = nodesSniffer;
        this.restClient = restClient;
        this.sniffIntervalMillis = sniffInterval;
        this.sniffAfterFailureDelayMillis = sniffAfterFailureDelay;
        this.scheduler = scheduler;
        Task task = new Task(this.sniffIntervalMillis){

            @Override
            public void run() {
                super.run();
                Sniffer.this.initialized.compareAndSet(false, true);
            }
        };
        scheduler.schedule(task, 0L);
    }

    public void sniffOnFailure() {
        if (this.initialized.get() && this.nextScheduledTask.skip()) {
            this.scheduler.schedule(new Task(this.sniffAfterFailureDelayMillis), 0L);
        }
    }

    final void sniff() throws IOException {
        List<Node> sniffedNodes = this.nodesSniffer.sniff();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sniffed nodes: " + String.valueOf(sniffedNodes)));
        }
        if (sniffedNodes.isEmpty()) {
            logger.warn((Object)"no nodes to set, nodes will be updated at the next sniffing round");
        } else {
            this.restClient.setNodes(sniffedNodes);
        }
    }

    @Override
    public void close() {
        if (this.initialized.get()) {
            this.nextScheduledTask.skip();
        }
        this.scheduler.shutdown();
    }

    public static SnifferBuilder builder(Rest5Client restClient) {
        return new SnifferBuilder(restClient);
    }

    static final class DefaultScheduler
    implements Scheduler {
        final ScheduledExecutorService executor;

        DefaultScheduler() {
            this(DefaultScheduler.initScheduledExecutorService());
        }

        DefaultScheduler(ScheduledExecutorService executor) {
            this.executor = executor;
        }

        private static ScheduledExecutorService initScheduledExecutorService() {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new SnifferThreadFactory(Sniffer.SNIFFER_THREAD_NAME));
            executor.setRemoveOnCancelPolicy(true);
            return executor;
        }

        @Override
        public Future<?> schedule(Task task, long delayMillis) {
            return this.executor.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        public void shutdown() {
            this.executor.shutdown();
            try {
                if (this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                this.executor.shutdownNow();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static interface Scheduler {
        public Future<?> schedule(Task var1, long var2);

        public void shutdown();
    }

    class Task
    implements Runnable {
        final long nextTaskDelay;
        final AtomicReference<TaskState> taskState = new AtomicReference<TaskState>(TaskState.WAITING);

        Task(long nextTaskDelay) {
            this.nextTaskDelay = nextTaskDelay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                if (!this.taskState.compareAndSet(TaskState.WAITING, TaskState.STARTED)) {
                    return;
                }
                try {
                    Sniffer.this.sniff();
                }
                catch (Exception e) {
                    logger.error((Object)"error while sniffing nodes", (Throwable)e);
                }
                finally {
                    Task task = new Task(Sniffer.this.sniffIntervalMillis);
                    Future<?> future = Sniffer.this.scheduler.schedule(task, this.nextTaskDelay);
                    ScheduledTask previousTask = Sniffer.this.nextScheduledTask;
                    Sniffer.this.nextScheduledTask = new ScheduledTask(task, future);
                    if ($assertionsDisabled || !Sniffer.this.initialized.get() || previousTask.task.isSkipped() || previousTask.task.hasStarted()) break block6;
                    throw new AssertionError((Object)"task that we are replacing is neither cancelled nor has it ever started");
                }
            }
        }

        boolean hasStarted() {
            return this.taskState.get() == TaskState.STARTED;
        }

        boolean skip() {
            return this.taskState.compareAndSet(TaskState.WAITING, TaskState.SKIPPED);
        }

        boolean isSkipped() {
            return this.taskState.get() == TaskState.SKIPPED;
        }
    }

    static final class ScheduledTask {
        final Task task;
        final Future<?> future;

        ScheduledTask(Task task, Future<?> future) {
            this.task = task;
            this.future = future;
        }

        boolean skip() {
            this.future.cancel(false);
            return this.task.skip();
        }
    }

    static class SnifferThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final ThreadFactory originalThreadFactory;

        private SnifferThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            this.originalThreadFactory = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.originalThreadFactory.newThread(r);
            t.setName(this.namePrefix + "[T#" + this.threadNumber.getAndIncrement() + "]");
            t.setDaemon(true);
            return t;
        }
    }

    static enum TaskState {
        WAITING,
        SKIPPED,
        STARTED;

    }
}

