/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.slm.ExecuteLifecycleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExecuteLifecycleRequest
extends RequestBase {
    @Nullable
    private final Time masterTimeout;
    private final String policyId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<ExecuteLifecycleRequest, ExecuteLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExecuteLifecycleRequest, ExecuteLifecycleResponse>("es/slm.execute_lifecycle", request -> "PUT", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId, buf);
            buf.append("/_execute");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("policyId", request.policyId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ExecuteLifecycleResponse._DESERIALIZER);

    private ExecuteLifecycleRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.policyId = ApiTypeHelper.requireNonNull(builder.policyId, this, "policyId");
        this.timeout = builder.timeout;
    }

    public static ExecuteLifecycleRequest of(Function<Builder, ObjectBuilder<ExecuteLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String policyId() {
        return this.policyId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ExecuteLifecycleRequest> {
        @Nullable
        private Time masterTimeout;
        private String policyId;
        @Nullable
        private Time timeout;

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExecuteLifecycleRequest build() {
            this._checkSingleUse();
            return new ExecuteLifecycleRequest(this);
        }
    }
}

