/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FilteringAdvancedSnippet
implements JsonpSerializable {
    @Nullable
    private final DateTime createdAt;
    @Nullable
    private final DateTime updatedAt;
    private final JsonData value;
    public static final JsonpDeserializer<FilteringAdvancedSnippet> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringAdvancedSnippet::setupFilteringAdvancedSnippetDeserializer);

    private FilteringAdvancedSnippet(Builder builder) {
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static FilteringAdvancedSnippet of(Function<Builder, ObjectBuilder<FilteringAdvancedSnippet>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime createdAt() {
        return this.createdAt;
    }

    @Nullable
    public final DateTime updatedAt() {
        return this.updatedAt;
    }

    public final JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.createdAt != null) {
            generator.writeKey("created_at");
            this.createdAt.serialize(generator, mapper);
        }
        if (this.updatedAt != null) {
            generator.writeKey("updated_at");
            this.updatedAt.serialize(generator, mapper);
        }
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFilteringAdvancedSnippetDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::createdAt, DateTime._DESERIALIZER, "created_at");
        op.add(Builder::updatedAt, DateTime._DESERIALIZER, "updated_at");
        op.add(Builder::value, JsonData._DESERIALIZER, "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringAdvancedSnippet> {
        @Nullable
        private DateTime createdAt;
        @Nullable
        private DateTime updatedAt;
        private JsonData value;

        public final Builder createdAt(@Nullable DateTime value) {
            this.createdAt = value;
            return this;
        }

        public final Builder updatedAt(@Nullable DateTime value) {
            this.updatedAt = value;
            return this;
        }

        public final Builder value(JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringAdvancedSnippet build() {
            this._checkSingleUse();
            return new FilteringAdvancedSnippet(this);
        }
    }
}

