/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client.low_level;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

class BasicAsyncEntityProducer
implements AsyncEntityProducer {
    private final HttpEntity entity;
    private final ByteBuffer buffer;
    private final AtomicReference<ReadableByteChannel> channelRef;
    private final AtomicReference<Exception> exceptionRef;
    private final String contentType;
    private final boolean isChunked;
    private boolean eof;

    BasicAsyncEntityProducer(HttpEntity entity, int bufferSize) {
        this.entity = (HttpEntity)Args.notNull((Object)entity, (String)"Http Entity");
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.channelRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
        this.contentType = entity.getContentType();
        this.isChunked = entity.isChunked();
    }

    BasicAsyncEntityProducer(HttpEntity entity) {
        this(entity, 8192);
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public int available() {
        return Integer.MAX_VALUE;
    }

    public String getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public Set<String> getTrailerNames() {
        return this.entity.getTrailerNames();
    }

    public void produce(DataStreamChannel dataStream) throws IOException {
        int bytesRead;
        ReadableByteChannel channel = this.channelRef.get();
        if (channel == null) {
            channel = Channels.newChannel(this.entity.getContent());
            this.channelRef.getAndSet(channel);
        }
        if (!this.eof && (bytesRead = channel.read(this.buffer)) < 0) {
            this.eof = true;
        }
        if (this.buffer.position() > 0) {
            ((Buffer)this.buffer).flip();
            dataStream.write(this.buffer);
            this.buffer.compact();
        }
        if (this.eof && this.buffer.position() == 0) {
            dataStream.endStream();
            this.releaseResources();
        }
    }

    public void failed(Exception cause) {
        if (this.exceptionRef.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public void releaseResources() {
        this.eof = false;
        ReadableByteChannel channel = this.channelRef.getAndSet(null);
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

