/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.ChangeTypeVariant;
import co.elastic.clients.elasticsearch._types.aggregations.Dip;
import co.elastic.clients.elasticsearch._types.aggregations.DistributionChange;
import co.elastic.clients.elasticsearch._types.aggregations.Indeterminable;
import co.elastic.clients.elasticsearch._types.aggregations.NonStationary;
import co.elastic.clients.elasticsearch._types.aggregations.Spike;
import co.elastic.clients.elasticsearch._types.aggregations.Stationary;
import co.elastic.clients.elasticsearch._types.aggregations.StepChange;
import co.elastic.clients.elasticsearch._types.aggregations.TrendChange;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ChangeType
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<ChangeType> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChangeType::setupChangeTypeDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public ChangeType(ChangeTypeVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._changeTypeKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private ChangeType(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static ChangeType of(Function<Builder, ObjectBuilder<ChangeType>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDip() {
        return this._kind == Kind.Dip;
    }

    public Dip dip() {
        return (Dip)TaggedUnionUtils.get(this, Kind.Dip);
    }

    public boolean isDistributionChange() {
        return this._kind == Kind.DistributionChange;
    }

    public DistributionChange distributionChange() {
        return (DistributionChange)TaggedUnionUtils.get(this, Kind.DistributionChange);
    }

    public boolean isIndeterminable() {
        return this._kind == Kind.Indeterminable;
    }

    public Indeterminable indeterminable() {
        return (Indeterminable)TaggedUnionUtils.get(this, Kind.Indeterminable);
    }

    public boolean isNonStationary() {
        return this._kind == Kind.NonStationary;
    }

    public NonStationary nonStationary() {
        return (NonStationary)TaggedUnionUtils.get(this, Kind.NonStationary);
    }

    public boolean isSpike() {
        return this._kind == Kind.Spike;
    }

    public Spike spike() {
        return (Spike)TaggedUnionUtils.get(this, Kind.Spike);
    }

    public boolean isStationary() {
        return this._kind == Kind.Stationary;
    }

    public Stationary stationary() {
        return (Stationary)TaggedUnionUtils.get(this, Kind.Stationary);
    }

    public boolean isStepChange() {
        return this._kind == Kind.StepChange;
    }

    public StepChange stepChange() {
        return (StepChange)TaggedUnionUtils.get(this, Kind.StepChange);
    }

    public boolean isTrendChange() {
        return this._kind == Kind.TrendChange;
    }

    public TrendChange trendChange() {
        return (TrendChange)TaggedUnionUtils.get(this, Kind.TrendChange);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupChangeTypeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dip, Dip._DESERIALIZER, "dip");
        op.add(Builder::distributionChange, DistributionChange._DESERIALIZER, "distribution_change");
        op.add(Builder::indeterminable, Indeterminable._DESERIALIZER, "indeterminable");
        op.add(Builder::nonStationary, NonStationary._DESERIALIZER, "non_stationary");
        op.add(Builder::spike, Spike._DESERIALIZER, "spike");
        op.add(Builder::stationary, Stationary._DESERIALIZER, "stationary");
        op.add(Builder::stepChange, StepChange._DESERIALIZER, "step_change");
        op.add(Builder::trendChange, TrendChange._DESERIALIZER, "trend_change");
    }

    public static enum Kind implements JsonEnum
    {
        Dip("dip"),
        DistributionChange("distribution_change"),
        Indeterminable("indeterminable"),
        NonStationary("non_stationary"),
        Spike("spike"),
        Stationary("stationary"),
        StepChange("step_change"),
        TrendChange("trend_change");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ChangeType> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<ChangeType> dip(Dip v) {
            this._kind = Kind.Dip;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> dip(Function<Dip.Builder, ObjectBuilder<Dip>> fn) {
            return this.dip(fn.apply(new Dip.Builder()).build());
        }

        public ObjectBuilder<ChangeType> distributionChange(DistributionChange v) {
            this._kind = Kind.DistributionChange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> distributionChange(Function<DistributionChange.Builder, ObjectBuilder<DistributionChange>> fn) {
            return this.distributionChange(fn.apply(new DistributionChange.Builder()).build());
        }

        public ObjectBuilder<ChangeType> indeterminable(Indeterminable v) {
            this._kind = Kind.Indeterminable;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> indeterminable(Function<Indeterminable.Builder, ObjectBuilder<Indeterminable>> fn) {
            return this.indeterminable(fn.apply(new Indeterminable.Builder()).build());
        }

        public ObjectBuilder<ChangeType> nonStationary(NonStationary v) {
            this._kind = Kind.NonStationary;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> nonStationary(Function<NonStationary.Builder, ObjectBuilder<NonStationary>> fn) {
            return this.nonStationary(fn.apply(new NonStationary.Builder()).build());
        }

        public ObjectBuilder<ChangeType> spike(Spike v) {
            this._kind = Kind.Spike;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> spike(Function<Spike.Builder, ObjectBuilder<Spike>> fn) {
            return this.spike(fn.apply(new Spike.Builder()).build());
        }

        public ObjectBuilder<ChangeType> stationary(Stationary v) {
            this._kind = Kind.Stationary;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> stationary(Function<Stationary.Builder, ObjectBuilder<Stationary>> fn) {
            return this.stationary(fn.apply(new Stationary.Builder()).build());
        }

        public ObjectBuilder<ChangeType> stepChange(StepChange v) {
            this._kind = Kind.StepChange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> stepChange(Function<StepChange.Builder, ObjectBuilder<StepChange>> fn) {
            return this.stepChange(fn.apply(new StepChange.Builder()).build());
        }

        public ObjectBuilder<ChangeType> trendChange(TrendChange v) {
            this._kind = Kind.TrendChange;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ChangeType> trendChange(Function<TrendChange.Builder, ObjectBuilder<TrendChange>> fn) {
            return this.trendChange(fn.apply(new TrendChange.Builder()).build());
        }

        @Override
        public ChangeType build() {
            this._checkSingleUse();
            return new ChangeType(this);
        }
    }
}

