/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.StandardDeviationBounds;
import co.elastic.clients.elasticsearch._types.aggregations.StandardDeviationBoundsAsString;
import co.elastic.clients.elasticsearch._types.aggregations.StatsAggregate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExtendedStatsAggregate
extends StatsAggregate
implements AggregateVariant {
    @Nullable
    private final Double sumOfSquares;
    @Nullable
    private final Double variance;
    @Nullable
    private final Double variancePopulation;
    @Nullable
    private final Double varianceSampling;
    @Nullable
    private final Double stdDeviation;
    @Nullable
    private final Double stdDeviationPopulation;
    @Nullable
    private final Double stdDeviationSampling;
    @Nullable
    private final StandardDeviationBounds stdDeviationBounds;
    @Nullable
    private final String sumOfSquaresAsString;
    @Nullable
    private final String varianceAsString;
    @Nullable
    private final String variancePopulationAsString;
    @Nullable
    private final String varianceSamplingAsString;
    @Nullable
    private final String stdDeviationAsString;
    @Nullable
    private final StandardDeviationBoundsAsString stdDeviationBoundsAsString;
    public static final JsonpDeserializer<ExtendedStatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedStatsAggregate::setupExtendedStatsAggregateDeserializer);

    protected ExtendedStatsAggregate(AbstractBuilder<?> builder) {
        super((StatsAggregate.AbstractBuilder<?>)builder);
        this.sumOfSquares = builder.sumOfSquares;
        this.variance = builder.variance;
        this.variancePopulation = builder.variancePopulation;
        this.varianceSampling = builder.varianceSampling;
        this.stdDeviation = builder.stdDeviation;
        this.stdDeviationPopulation = builder.stdDeviationPopulation;
        this.stdDeviationSampling = builder.stdDeviationSampling;
        this.stdDeviationBounds = builder.stdDeviationBounds;
        this.sumOfSquaresAsString = builder.sumOfSquaresAsString;
        this.varianceAsString = builder.varianceAsString;
        this.variancePopulationAsString = builder.variancePopulationAsString;
        this.varianceSamplingAsString = builder.varianceSamplingAsString;
        this.stdDeviationAsString = builder.stdDeviationAsString;
        this.stdDeviationBoundsAsString = builder.stdDeviationBoundsAsString;
    }

    public static ExtendedStatsAggregate extendedStatsAggregateOf(Function<Builder, ObjectBuilder<ExtendedStatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.ExtendedStats;
    }

    @Nullable
    public final Double sumOfSquares() {
        return this.sumOfSquares;
    }

    @Nullable
    public final Double variance() {
        return this.variance;
    }

    @Nullable
    public final Double variancePopulation() {
        return this.variancePopulation;
    }

    @Nullable
    public final Double varianceSampling() {
        return this.varianceSampling;
    }

    @Nullable
    public final Double stdDeviation() {
        return this.stdDeviation;
    }

    @Nullable
    public final Double stdDeviationPopulation() {
        return this.stdDeviationPopulation;
    }

    @Nullable
    public final Double stdDeviationSampling() {
        return this.stdDeviationSampling;
    }

    @Nullable
    public final StandardDeviationBounds stdDeviationBounds() {
        return this.stdDeviationBounds;
    }

    @Nullable
    public final String sumOfSquaresAsString() {
        return this.sumOfSquaresAsString;
    }

    @Nullable
    public final String varianceAsString() {
        return this.varianceAsString;
    }

    @Nullable
    public final String variancePopulationAsString() {
        return this.variancePopulationAsString;
    }

    @Nullable
    public final String varianceSamplingAsString() {
        return this.varianceSamplingAsString;
    }

    @Nullable
    public final String stdDeviationAsString() {
        return this.stdDeviationAsString;
    }

    @Nullable
    public final StandardDeviationBoundsAsString stdDeviationBoundsAsString() {
        return this.stdDeviationBoundsAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.sumOfSquares != null) {
            generator.writeKey("sum_of_squares");
            generator.write(this.sumOfSquares.doubleValue());
        }
        if (this.variance != null) {
            generator.writeKey("variance");
            generator.write(this.variance.doubleValue());
        }
        if (this.variancePopulation != null) {
            generator.writeKey("variance_population");
            generator.write(this.variancePopulation.doubleValue());
        }
        if (this.varianceSampling != null) {
            generator.writeKey("variance_sampling");
            generator.write(this.varianceSampling.doubleValue());
        }
        if (this.stdDeviation != null) {
            generator.writeKey("std_deviation");
            generator.write(this.stdDeviation.doubleValue());
        }
        if (this.stdDeviationPopulation != null) {
            generator.writeKey("std_deviation_population");
            generator.write(this.stdDeviationPopulation.doubleValue());
        }
        if (this.stdDeviationSampling != null) {
            generator.writeKey("std_deviation_sampling");
            generator.write(this.stdDeviationSampling.doubleValue());
        }
        if (this.stdDeviationBounds != null) {
            generator.writeKey("std_deviation_bounds");
            this.stdDeviationBounds.serialize(generator, mapper);
        }
        if (this.sumOfSquaresAsString != null) {
            generator.writeKey("sum_of_squares_as_string");
            generator.write(this.sumOfSquaresAsString);
        }
        if (this.varianceAsString != null) {
            generator.writeKey("variance_as_string");
            generator.write(this.varianceAsString);
        }
        if (this.variancePopulationAsString != null) {
            generator.writeKey("variance_population_as_string");
            generator.write(this.variancePopulationAsString);
        }
        if (this.varianceSamplingAsString != null) {
            generator.writeKey("variance_sampling_as_string");
            generator.write(this.varianceSamplingAsString);
        }
        if (this.stdDeviationAsString != null) {
            generator.writeKey("std_deviation_as_string");
            generator.write(this.stdDeviationAsString);
        }
        if (this.stdDeviationBoundsAsString != null) {
            generator.writeKey("std_deviation_bounds_as_string");
            this.stdDeviationBoundsAsString.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupExtendedStatsAggregateDeserializer(ObjectDeserializer<BuilderT> op) {
        StatsAggregate.setupStatsAggregateDeserializer(op);
        op.add(AbstractBuilder::sumOfSquares, JsonpDeserializer.doubleDeserializer(), "sum_of_squares");
        op.add(AbstractBuilder::variance, JsonpDeserializer.doubleDeserializer(), "variance");
        op.add(AbstractBuilder::variancePopulation, JsonpDeserializer.doubleDeserializer(), "variance_population");
        op.add(AbstractBuilder::varianceSampling, JsonpDeserializer.doubleDeserializer(), "variance_sampling");
        op.add(AbstractBuilder::stdDeviation, JsonpDeserializer.doubleDeserializer(), "std_deviation");
        op.add(AbstractBuilder::stdDeviationPopulation, JsonpDeserializer.doubleDeserializer(), "std_deviation_population");
        op.add(AbstractBuilder::stdDeviationSampling, JsonpDeserializer.doubleDeserializer(), "std_deviation_sampling");
        op.add(AbstractBuilder::stdDeviationBounds, StandardDeviationBounds._DESERIALIZER, "std_deviation_bounds");
        op.add(AbstractBuilder::sumOfSquaresAsString, JsonpDeserializer.stringDeserializer(), "sum_of_squares_as_string");
        op.add(AbstractBuilder::varianceAsString, JsonpDeserializer.stringDeserializer(), "variance_as_string");
        op.add(AbstractBuilder::variancePopulationAsString, JsonpDeserializer.stringDeserializer(), "variance_population_as_string");
        op.add(AbstractBuilder::varianceSamplingAsString, JsonpDeserializer.stringDeserializer(), "variance_sampling_as_string");
        op.add(AbstractBuilder::stdDeviationAsString, JsonpDeserializer.stringDeserializer(), "std_deviation_as_string");
        op.add(AbstractBuilder::stdDeviationBoundsAsString, StandardDeviationBoundsAsString._DESERIALIZER, "std_deviation_bounds_as_string");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends StatsAggregate.AbstractBuilder<BuilderT> {
        @Nullable
        private Double sumOfSquares;
        @Nullable
        private Double variance;
        @Nullable
        private Double variancePopulation;
        @Nullable
        private Double varianceSampling;
        @Nullable
        private Double stdDeviation;
        @Nullable
        private Double stdDeviationPopulation;
        @Nullable
        private Double stdDeviationSampling;
        @Nullable
        private StandardDeviationBounds stdDeviationBounds;
        @Nullable
        private String sumOfSquaresAsString;
        @Nullable
        private String varianceAsString;
        @Nullable
        private String variancePopulationAsString;
        @Nullable
        private String varianceSamplingAsString;
        @Nullable
        private String stdDeviationAsString;
        @Nullable
        private StandardDeviationBoundsAsString stdDeviationBoundsAsString;

        public final BuilderT sumOfSquares(@Nullable Double value) {
            this.sumOfSquares = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT variance(@Nullable Double value) {
            this.variance = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT variancePopulation(@Nullable Double value) {
            this.variancePopulation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT varianceSampling(@Nullable Double value) {
            this.varianceSampling = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviation(@Nullable Double value) {
            this.stdDeviation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationPopulation(@Nullable Double value) {
            this.stdDeviationPopulation = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationSampling(@Nullable Double value) {
            this.stdDeviationSampling = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBounds(@Nullable StandardDeviationBounds value) {
            this.stdDeviationBounds = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBounds(Function<StandardDeviationBounds.Builder, ObjectBuilder<StandardDeviationBounds>> fn) {
            return this.stdDeviationBounds(fn.apply(new StandardDeviationBounds.Builder()).build());
        }

        public final BuilderT sumOfSquaresAsString(@Nullable String value) {
            this.sumOfSquaresAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT varianceAsString(@Nullable String value) {
            this.varianceAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT variancePopulationAsString(@Nullable String value) {
            this.variancePopulationAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT varianceSamplingAsString(@Nullable String value) {
            this.varianceSamplingAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationAsString(@Nullable String value) {
            this.stdDeviationAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBoundsAsString(@Nullable StandardDeviationBoundsAsString value) {
            this.stdDeviationBoundsAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stdDeviationBoundsAsString(Function<StandardDeviationBoundsAsString.Builder, ObjectBuilder<StandardDeviationBoundsAsString>> fn) {
            return this.stdDeviationBoundsAsString(fn.apply(new StandardDeviationBoundsAsString.Builder()).build());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedStatsAggregate> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedStatsAggregate build() {
            this._checkSingleUse();
            return new ExtendedStatsAggregate(this);
        }
    }
}

