/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class SingleMetricAggregateBase
extends AggregateBase {
    @Nullable
    private final Double value;
    @Nullable
    private final String valueAsString;

    protected SingleMetricAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.value = builder.value;
        this.valueAsString = builder.valueAsString;
    }

    @Nullable
    public final Double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value.doubleValue());
        }
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleMetricAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::value, JsonpDeserializer.doubleDeserializer(), "value");
        op.add(AbstractBuilder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double value;
        @Nullable
        private String valueAsString;

        public final BuilderT value(@Nullable Double value) {
            this.value = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

