/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransportBase;
import co.elastic.clients.transport.ElasticsearchTransportConfig;
import co.elastic.clients.transport.Transport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.instrumentation.Instrumentation;
import co.elastic.clients.transport.rest_client.RestClientHttpClient;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import java.net.URI;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class RestClientTransport
extends ElasticsearchTransportBase {
    private final RestClient restClient;

    public RestClientTransport(ElasticsearchTransportConfig config) {
        this(RestClientTransport.buildRestClient(config), config.mapper(), RestClientOptions.of(config.transportOptions()), config.instrumentation());
    }

    public RestClientTransport(RestClient restClient, JsonpMapper jsonpMapper) {
        this(restClient, jsonpMapper, null);
    }

    public RestClientTransport(RestClient restClient, JsonpMapper jsonpMapper, RestClientOptions options) {
        super(new RestClientHttpClient(restClient), options, jsonpMapper, null);
        this.restClient = restClient;
    }

    public RestClientTransport(RestClient restClient, JsonpMapper jsonpMapper, RestClientOptions options, Instrumentation instrumentation) {
        super(new RestClientHttpClient(restClient), options, jsonpMapper, instrumentation);
        this.restClient = restClient;
    }

    private static RestClient buildRestClient(ElasticsearchTransportConfig config) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])((HttpHost[])config.hosts().stream().map(h -> new HttpHost(h.getHost(), h.getPort(), h.getScheme())).toArray(HttpHost[]::new)));
        String prefix = config.hosts().get(0).getPath();
        if (config.hosts().size() > 1) {
            for (URI host : config.hosts()) {
                if (Objects.equals(host.getPath(), prefix)) continue;
                throw new IllegalArgumentException("All hosts must have the same URL path (" + String.valueOf(config.hosts().get(0)) + " and " + String.valueOf(host) + ")");
            }
        }
        if (prefix != null && !prefix.isEmpty()) {
            restClientBuilder.setPathPrefix(prefix);
        }
        if (config.username() != null && config.password() != null) {
            String cred = Base64.getEncoder().encodeToString((config.username() + ":" + config.password()).getBytes());
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Basic " + cred)});
        } else if (config.apiKey() != null) {
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "ApiKey " + config.apiKey())});
        } else if (config.token() != null) {
            restClientBuilder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "Bearer " + config.token())});
        }
        if (config.sslContext() != null) {
            restClientBuilder.setHttpClientConfigCallback(hc -> hc.setSSLContext(config.sslContext()));
        }
        restClientBuilder.setCompressionEnabled(config.useCompression());
        return restClientBuilder.build();
    }

    public RestClient restClient() {
        return this.restClient;
    }

    @Override
    public Transport withOptions(@Nullable TransportOptions options) {
        return new RestClientTransport(this.restClient, this.mapper, RestClientOptions.of(options), this.instrumentation);
    }

    @Override
    protected ElasticsearchTransportBase cloneWith(TransportOptions options, JsonpMapper mapper, Instrumentation instrumentation) {
        return new RestClientTransport(this.restClient, mapper != null ? mapper : this.mapper, RestClientOptions.of(options != null ? options : this.transportOptions), instrumentation != null ? instrumentation : this.instrumentation);
    }
}

