/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Influencer
implements JsonpSerializable {
    private final long bucketSpan;
    private final double influencerScore;
    private final String influencerFieldName;
    private final String influencerFieldValue;
    private final double initialInfluencerScore;
    private final boolean isInterim;
    private final String jobId;
    private final double probability;
    private final String resultType;
    private final long timestamp;
    @Nullable
    private final String foo;
    public static final JsonpDeserializer<Influencer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Influencer::setupInfluencerDeserializer);

    private Influencer(Builder builder) {
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, (Object)this, "bucketSpan", 0L);
        this.influencerScore = ApiTypeHelper.requireNonNull(builder.influencerScore, (Object)this, "influencerScore", 0.0);
        this.influencerFieldName = ApiTypeHelper.requireNonNull(builder.influencerFieldName, this, "influencerFieldName");
        this.influencerFieldValue = ApiTypeHelper.requireNonNull(builder.influencerFieldValue, this, "influencerFieldValue");
        this.initialInfluencerScore = ApiTypeHelper.requireNonNull(builder.initialInfluencerScore, (Object)this, "initialInfluencerScore", 0.0);
        this.isInterim = ApiTypeHelper.requireNonNull(builder.isInterim, (Object)this, "isInterim", false);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.probability = ApiTypeHelper.requireNonNull(builder.probability, (Object)this, "probability", 0.0);
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, (Object)this, "timestamp", 0L);
        this.foo = builder.foo;
    }

    public static Influencer of(Function<Builder, ObjectBuilder<Influencer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bucketSpan() {
        return this.bucketSpan;
    }

    public final double influencerScore() {
        return this.influencerScore;
    }

    public final String influencerFieldName() {
        return this.influencerFieldName;
    }

    public final String influencerFieldValue() {
        return this.influencerFieldValue;
    }

    public final double initialInfluencerScore() {
        return this.initialInfluencerScore;
    }

    public final boolean isInterim() {
        return this.isInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final double probability() {
        return this.probability;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String foo() {
        return this.foo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("influencer_score");
        generator.write(this.influencerScore);
        generator.writeKey("influencer_field_name");
        generator.write(this.influencerFieldName);
        generator.writeKey("influencer_field_value");
        generator.write(this.influencerFieldValue);
        generator.writeKey("initial_influencer_score");
        generator.write(this.initialInfluencerScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.foo != null) {
            generator.writeKey("foo");
            generator.write(this.foo);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInfluencerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span");
        op.add(Builder::influencerScore, JsonpDeserializer.doubleDeserializer(), "influencer_score");
        op.add(Builder::influencerFieldName, JsonpDeserializer.stringDeserializer(), "influencer_field_name");
        op.add(Builder::influencerFieldValue, JsonpDeserializer.stringDeserializer(), "influencer_field_value");
        op.add(Builder::initialInfluencerScore, JsonpDeserializer.doubleDeserializer(), "initial_influencer_score");
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::foo, JsonpDeserializer.stringDeserializer(), "foo");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Influencer> {
        private Long bucketSpan;
        private Double influencerScore;
        private String influencerFieldName;
        private String influencerFieldValue;
        private Double initialInfluencerScore;
        private Boolean isInterim;
        private String jobId;
        private Double probability;
        private String resultType;
        private Long timestamp;
        @Nullable
        private String foo;

        public final Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder influencerScore(double value) {
            this.influencerScore = value;
            return this;
        }

        public final Builder influencerFieldName(String value) {
            this.influencerFieldName = value;
            return this;
        }

        public final Builder influencerFieldValue(String value) {
            this.influencerFieldValue = value;
            return this;
        }

        public final Builder initialInfluencerScore(double value) {
            this.initialInfluencerScore = value;
            return this;
        }

        public final Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder foo(@Nullable String value) {
            this.foo = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Influencer build() {
            this._checkSingleUse();
            return new Influencer(this);
        }
    }
}

