/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DiscoveryNodeContent
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final String name;
    private final String ephemeralId;
    private final String transportAddress;
    private final String externalId;
    private final Map<String, String> attributes;
    private final List<String> roles;
    private final String version;
    private final int minIndexVersion;
    private final int maxIndexVersion;
    public static final JsonpDeserializer<DiscoveryNodeContent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiscoveryNodeContent::setupDiscoveryNodeContentDeserializer);

    private DiscoveryNodeContent(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = builder.name;
        this.ephemeralId = ApiTypeHelper.requireNonNull(builder.ephemeralId, this, "ephemeralId");
        this.transportAddress = ApiTypeHelper.requireNonNull(builder.transportAddress, this, "transportAddress");
        this.externalId = ApiTypeHelper.requireNonNull(builder.externalId, this, "externalId");
        this.attributes = ApiTypeHelper.unmodifiableRequired(builder.attributes, (Object)this, "attributes");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.minIndexVersion = ApiTypeHelper.requireNonNull(builder.minIndexVersion, (Object)this, "minIndexVersion", 0);
        this.maxIndexVersion = ApiTypeHelper.requireNonNull(builder.maxIndexVersion, (Object)this, "maxIndexVersion", 0);
    }

    public static DiscoveryNodeContent of(Function<Builder, ObjectBuilder<DiscoveryNodeContent>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public final String ephemeralId() {
        return this.ephemeralId;
    }

    public final String transportAddress() {
        return this.transportAddress;
    }

    public final String externalId() {
        return this.externalId;
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String version() {
        return this.version;
    }

    public final int minIndexVersion() {
        return this.minIndexVersion;
    }

    public final int maxIndexVersion() {
        return this.maxIndexVersion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.id);
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        generator.writeKey("ephemeral_id");
        generator.write(this.ephemeralId);
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("external_id");
        generator.write(this.externalId);
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartObject();
            for (Map.Entry entry : this.attributes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("min_index_version");
        generator.write(this.minIndexVersion);
        generator.writeKey("max_index_version");
        generator.write(this.maxIndexVersion);
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDiscoveryNodeContentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::ephemeralId, JsonpDeserializer.stringDeserializer(), "ephemeral_id");
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address");
        op.add(Builder::externalId, JsonpDeserializer.stringDeserializer(), "external_id");
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::minIndexVersion, JsonpDeserializer.integerDeserializer(), "min_index_version");
        op.add(Builder::maxIndexVersion, JsonpDeserializer.integerDeserializer(), "max_index_version");
        op.setKey(Builder::id, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DiscoveryNodeContent> {
        private String id;
        @Nullable
        private String name;
        private String ephemeralId;
        private String transportAddress;
        private String externalId;
        private Map<String, String> attributes;
        private List<String> roles;
        private String version;
        private Integer minIndexVersion;
        private Integer maxIndexVersion;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder ephemeralId(String value) {
            this.ephemeralId = value;
            return this;
        }

        public final Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public final Builder externalId(String value) {
            this.externalId = value;
            return this;
        }

        public final Builder attributes(Map<String, String> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        public final Builder attributes(String key, String value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder minIndexVersion(int value) {
            this.minIndexVersion = value;
            return this;
        }

        public final Builder maxIndexVersion(int value) {
            this.maxIndexVersion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DiscoveryNodeContent build() {
            this._checkSingleUse();
            return new DiscoveryNodeContent(this);
        }
    }
}

