/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest5_client;

import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.rest5_client.Rest5ClientTransport;
import co.elastic.clients.transport.rest5_client.low_level.RequestOptions;
import co.elastic.clients.transport.rest5_client.low_level.WarningsHandler;
import co.elastic.clients.util.LanguageRuntimeVersions;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.core5.util.VersionInfo;

public class Rest5ClientOptions
implements TransportOptions {
    private final RequestOptions options;
    boolean keepResponseBodyOnException;
    static final String CLIENT_META_VALUE = Rest5ClientOptions.getClientMeta();
    static final String USER_AGENT_VALUE = Rest5ClientOptions.getUserAgent();

    public static Rest5ClientOptions of(@Nullable TransportOptions options) {
        if (options == null) {
            return Rest5ClientOptions.initialOptions();
        }
        if (options instanceof Rest5ClientOptions) {
            return (Rest5ClientOptions)options;
        }
        Builder builder = new Builder(RequestOptions.DEFAULT.toBuilder());
        options.headers().forEach(h -> builder.addHeader((String)h.getKey(), (String)h.getValue()));
        options.queryParameters().forEach(builder::setParameter);
        builder.onWarnings(options.onWarnings());
        return builder.build();
    }

    public Rest5ClientOptions(RequestOptions options, boolean keepResponseBodyOnException) {
        this.keepResponseBodyOnException = keepResponseBodyOnException;
        this.options = Rest5ClientOptions.addBuiltinHeaders(options.toBuilder()).build();
    }

    public RequestOptions restClientRequestOptions() {
        return this.options;
    }

    @Override
    public Collection<Map.Entry<String, String>> headers() {
        return this.options.getHeaders().stream().map(h -> new AbstractMap.SimpleImmutableEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> queryParameters() {
        return this.options.getParameters();
    }

    @Override
    public Function<List<String>, Boolean> onWarnings() {
        WarningsHandler handler = this.options.getWarningsHandler();
        if (handler == null) {
            return null;
        }
        return warnings -> this.options.getWarningsHandler().warningsShouldFailRequest((List<String>)warnings);
    }

    @Override
    public void updateToken(String token) {
        this.options.updateToken(token);
    }

    @Override
    public boolean keepResponseBodyOnException() {
        return this.keepResponseBodyOnException;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.options.toBuilder());
    }

    static Rest5ClientOptions initialOptions() {
        return new Rest5ClientOptions(RequestOptions.DEFAULT, false);
    }

    private static RequestOptions.Builder addBuiltinHeaders(RequestOptions.Builder builder) {
        builder.removeHeader("X-Elastic-Client-Meta");
        builder.addHeader("X-Elastic-Client-Meta", CLIENT_META_VALUE);
        if (builder.getHeaders().stream().noneMatch(h -> h.getName().equalsIgnoreCase("User-Agent"))) {
            builder.addHeader("User-Agent", USER_AGENT_VALUE);
        }
        if (builder.getHeaders().stream().noneMatch(h -> h.getName().equalsIgnoreCase("Accept"))) {
            builder.addHeader("Accept", Rest5ClientTransport.JSON_CONTENT_TYPE);
        }
        return builder;
    }

    private static String getUserAgent() {
        return String.format(Locale.ROOT, "elastic-java/%s (Java/%s)", Version.VERSION == null ? "Unknown" : Version.VERSION.toString(), System.getProperty("java.version"));
    }

    private static String getClientMeta() {
        VersionInfo httpClientVersion = null;
        try {
            httpClientVersion = VersionInfo.loadVersionInfo((String)"org.apache.http.nio.client", (ClassLoader)HttpAsyncClientBuilder.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object metaVersion = Version.VERSION == null ? "" : Version.VERSION.toString();
        int dashPos = ((String)metaVersion).indexOf(45);
        if (dashPos > 0) {
            metaVersion = ((String)metaVersion).substring(0, dashPos) + "p";
        }
        return "es=" + (String)metaVersion + ",jv=" + System.getProperty("java.specification.version") + ",t=" + (String)metaVersion + ",hl=2,hc=" + (httpClientVersion == null ? "" : httpClientVersion.getRelease()) + LanguageRuntimeVersions.getRuntimeMetadata();
    }

    public static class Builder
    implements TransportOptions.Builder {
        private RequestOptions.Builder builder;
        private boolean keepResponseBodyOnException;

        public Builder(RequestOptions.Builder builder) {
            this.builder = builder;
        }

        public RequestOptions.Builder restClientRequestOptionsBuilder() {
            return this.builder;
        }

        @Override
        public TransportOptions.Builder addHeader(String name, String value) {
            if (name.equalsIgnoreCase("X-Elastic-Client-Meta")) {
                return this;
            }
            if (name.equalsIgnoreCase("User-Agent")) {
                this.builder.removeHeader("User-Agent");
            }
            this.builder.addHeader(name, value);
            return this;
        }

        @Override
        public TransportOptions.Builder setHeader(String name, String value) {
            if (name.equalsIgnoreCase("X-Elastic-Client-Meta")) {
                return this;
            }
            this.builder.removeHeader(name).addHeader(name, value);
            return this;
        }

        @Override
        public TransportOptions.Builder removeHeader(String name) {
            this.builder.removeHeader(name);
            return this;
        }

        @Override
        public TransportOptions.Builder setParameter(String name, String value) {
            this.builder.addParameter(name, value);
            return this;
        }

        @Override
        public TransportOptions.Builder removeParameter(String name) {
            throw new UnsupportedOperationException("This implementation does not support removing parameters");
        }

        @Override
        public TransportOptions.Builder onWarnings(Function<List<String>, Boolean> listener) {
            if (listener == null) {
                this.builder.setWarningsHandler(null);
            } else {
                this.builder.setWarningsHandler(w -> {
                    if (w != null && !w.isEmpty()) {
                        return (Boolean)listener.apply(w);
                    }
                    return false;
                });
            }
            return this;
        }

        @Override
        public TransportOptions.Builder keepResponseBodyOnException(boolean value) {
            this.keepResponseBodyOnException = value;
            return this;
        }

        @Override
        public Rest5ClientOptions build() {
            return new Rest5ClientOptions(Rest5ClientOptions.addBuiltinHeaders(this.builder).build(), this.keepResponseBodyOnException);
        }
    }
}

