/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.esql;

import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapter;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlMetadata;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.stream.JsonParser;

public abstract class EsqlAdapterBase<T>
implements EsqlAdapter<T> {
    public static EsqlMetadata readHeader(JsonParser parser, JsonpMapper mapper) {
        EsqlMetadata result = new EsqlMetadata();
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.START_OBJECT);
        block10: while (JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME) != null) {
            switch (parser.getString()) {
                case "values": {
                    break block10;
                }
                case "columns": {
                    result.columns = JsonpDeserializer.arrayDeserializer(EsqlMetadata.EsqlColumn._DESERIALIZER).deserialize(parser, mapper);
                    continue block10;
                }
                case "took": {
                    JsonpUtils.expectNextEvent(parser, JsonParser.Event.VALUE_NUMBER);
                    result.took = parser.getLong();
                    continue block10;
                }
                default: {
                    JsonpUtils.skipValue(parser);
                    continue block10;
                }
            }
        }
        if (result.columns == null) {
            throw new JsonpMappingException("Expecting a 'columns' property before 'values'.", parser.getLocation());
        }
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.START_ARRAY);
        return result;
    }

    public static void readFooter(JsonParser parser) {
        while (parser.next() != JsonParser.Event.END_OBJECT) {
            JsonpUtils.skipValue(parser);
        }
    }
}

