/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch.security.TemplateFormat;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleTemplate
implements JsonpSerializable {
    @Nullable
    private final TemplateFormat format;
    private final Script template;
    public static final JsonpDeserializer<RoleTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleTemplate::setupRoleTemplateDeserializer);

    private RoleTemplate(Builder builder) {
        this.format = builder.format;
        this.template = ApiTypeHelper.requireNonNull(builder.template, this, "template");
    }

    public static RoleTemplate of(Function<Builder, ObjectBuilder<RoleTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TemplateFormat format() {
        return this.format;
    }

    public final Script template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.format != null) {
            generator.writeKey("format");
            this.format.serialize(generator, mapper);
        }
        generator.writeKey("template");
        this.template.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRoleTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::format, TemplateFormat._DESERIALIZER, "format");
        op.add(Builder::template, Script._DESERIALIZER, "template");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RoleTemplate> {
        @Nullable
        private TemplateFormat format;
        private Script template;

        public final Builder format(@Nullable TemplateFormat value) {
            this.format = value;
            return this;
        }

        public final Builder template(Script value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.template(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RoleTemplate build() {
            this._checkSingleUse();
            return new RoleTemplate(this);
        }
    }
}

