/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.watcher.ConnectionScheme;
import co.elastic.clients.elasticsearch.watcher.HttpInputAuthentication;
import co.elastic.clients.elasticsearch.watcher.HttpInputMethod;
import co.elastic.clients.elasticsearch.watcher.HttpInputProxy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HttpInputRequestDefinition
implements JsonpSerializable {
    @Nullable
    private final HttpInputAuthentication auth;
    @Nullable
    private final String body;
    @Nullable
    private final Time connectionTimeout;
    private final Map<String, String> headers;
    @Nullable
    private final String host;
    @Nullable
    private final HttpInputMethod method;
    private final Map<String, String> params;
    @Nullable
    private final String path;
    @Nullable
    private final Number port;
    @Nullable
    private final HttpInputProxy proxy;
    @Nullable
    private final Time readTimeout;
    @Nullable
    private final ConnectionScheme scheme;
    @Nullable
    private final String url;
    public static final JsonpDeserializer<HttpInputRequestDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInputRequestDefinition::setupHttpInputRequestDefinitionDeserializer);

    protected HttpInputRequestDefinition(AbstractBuilder<?> builder) {
        this.auth = builder.auth;
        this.body = builder.body;
        this.connectionTimeout = builder.connectionTimeout;
        this.headers = ApiTypeHelper.unmodifiable(builder.headers);
        this.host = builder.host;
        this.method = builder.method;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.path = builder.path;
        this.port = builder.port;
        this.proxy = builder.proxy;
        this.readTimeout = builder.readTimeout;
        this.scheme = builder.scheme;
        this.url = builder.url;
    }

    public static HttpInputRequestDefinition httpInputRequestDefinitionOf(Function<Builder, ObjectBuilder<HttpInputRequestDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final HttpInputAuthentication auth() {
        return this.auth;
    }

    @Nullable
    public final String body() {
        return this.body;
    }

    @Nullable
    public final Time connectionTimeout() {
        return this.connectionTimeout;
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final HttpInputMethod method() {
        return this.method;
    }

    public final Map<String, String> params() {
        return this.params;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Nullable
    public final Number port() {
        return this.port;
    }

    @Nullable
    public final HttpInputProxy proxy() {
        return this.proxy;
    }

    @Nullable
    public final Time readTimeout() {
        return this.readTimeout;
    }

    @Nullable
    public final ConnectionScheme scheme() {
        return this.scheme;
    }

    @Nullable
    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.auth != null) {
            generator.writeKey("auth");
            this.auth.serialize(generator, mapper);
        }
        if (this.body != null) {
            generator.writeKey("body");
            generator.write(this.body);
        }
        if (this.connectionTimeout != null) {
            generator.writeKey("connection_timeout");
            this.connectionTimeout.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        if (this.port != null) {
            generator.writeKey("port");
            generator.write(this.port.doubleValue());
        }
        if (this.proxy != null) {
            generator.writeKey("proxy");
            this.proxy.serialize(generator, mapper);
        }
        if (this.readTimeout != null) {
            generator.writeKey("read_timeout");
            this.readTimeout.serialize(generator, mapper);
        }
        if (this.scheme != null) {
            generator.writeKey("scheme");
            this.scheme.serialize(generator, mapper);
        }
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupHttpInputRequestDefinitionDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::auth, HttpInputAuthentication._DESERIALIZER, "auth");
        op.add(AbstractBuilder::body, JsonpDeserializer.stringDeserializer(), "body");
        op.add(AbstractBuilder::connectionTimeout, Time._DESERIALIZER, "connection_timeout");
        op.add(AbstractBuilder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers");
        op.add(AbstractBuilder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(AbstractBuilder::method, HttpInputMethod._DESERIALIZER, "method");
        op.add(AbstractBuilder::params, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "params");
        op.add(AbstractBuilder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(AbstractBuilder::port, JsonpDeserializer.numberDeserializer(), "port");
        op.add(AbstractBuilder::proxy, HttpInputProxy._DESERIALIZER, "proxy");
        op.add(AbstractBuilder::readTimeout, Time._DESERIALIZER, "read_timeout");
        op.add(AbstractBuilder::scheme, ConnectionScheme._DESERIALIZER, "scheme");
        op.add(AbstractBuilder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private HttpInputAuthentication auth;
        @Nullable
        private String body;
        @Nullable
        private Time connectionTimeout;
        @Nullable
        private Map<String, String> headers;
        @Nullable
        private String host;
        @Nullable
        private HttpInputMethod method;
        @Nullable
        private Map<String, String> params;
        @Nullable
        private String path;
        @Nullable
        private Number port;
        @Nullable
        private HttpInputProxy proxy;
        @Nullable
        private Time readTimeout;
        @Nullable
        private ConnectionScheme scheme;
        @Nullable
        private String url;

        public final BuilderT auth(@Nullable HttpInputAuthentication value) {
            this.auth = value;
            return (BuilderT)this.self();
        }

        public final BuilderT auth(Function<HttpInputAuthentication.Builder, ObjectBuilder<HttpInputAuthentication>> fn) {
            return this.auth(fn.apply(new HttpInputAuthentication.Builder()).build());
        }

        public final BuilderT body(@Nullable String value) {
            this.body = value;
            return (BuilderT)this.self();
        }

        public final BuilderT connectionTimeout(@Nullable Time value) {
            this.connectionTimeout = value;
            return (BuilderT)this.self();
        }

        public final BuilderT connectionTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.connectionTimeout(fn.apply(new Time.Builder()).build());
        }

        public final BuilderT headers(Map<String, String> map) {
            this.headers = AbstractBuilder._mapPutAll(this.headers, map);
            return (BuilderT)this.self();
        }

        public final BuilderT headers(String key, String value) {
            this.headers = AbstractBuilder._mapPut(this.headers, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT host(@Nullable String value) {
            this.host = value;
            return (BuilderT)this.self();
        }

        public final BuilderT method(@Nullable HttpInputMethod value) {
            this.method = value;
            return (BuilderT)this.self();
        }

        public final BuilderT params(Map<String, String> map) {
            this.params = AbstractBuilder._mapPutAll(this.params, map);
            return (BuilderT)this.self();
        }

        public final BuilderT params(String key, String value) {
            this.params = AbstractBuilder._mapPut(this.params, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT path(@Nullable String value) {
            this.path = value;
            return (BuilderT)this.self();
        }

        public final BuilderT port(@Nullable Number value) {
            this.port = value;
            return (BuilderT)this.self();
        }

        public final BuilderT proxy(@Nullable HttpInputProxy value) {
            this.proxy = value;
            return (BuilderT)this.self();
        }

        public final BuilderT proxy(Function<HttpInputProxy.Builder, ObjectBuilder<HttpInputProxy>> fn) {
            return this.proxy(fn.apply(new HttpInputProxy.Builder()).build());
        }

        public final BuilderT readTimeout(@Nullable Time value) {
            this.readTimeout = value;
            return (BuilderT)this.self();
        }

        public final BuilderT readTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.readTimeout(fn.apply(new Time.Builder()).build());
        }

        public final BuilderT scheme(@Nullable ConnectionScheme value) {
            this.scheme = value;
            return (BuilderT)this.self();
        }

        public final BuilderT url(@Nullable String value) {
            this.url = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<HttpInputRequestDefinition> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpInputRequestDefinition build() {
            this._checkSingleUse();
            return new HttpInputRequestDefinition(this);
        }
    }
}

