/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.LaplaceSmoothingModel;
import co.elastic.clients.elasticsearch.core.search.LinearInterpolationSmoothingModel;
import co.elastic.clients.elasticsearch.core.search.SmoothingModelVariant;
import co.elastic.clients.elasticsearch.core.search.StupidBackoffSmoothingModel;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SmoothingModel
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SmoothingModel> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SmoothingModel::setupSmoothingModelDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public SmoothingModel(SmoothingModelVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._smoothingModelKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private SmoothingModel(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SmoothingModel of(Function<Builder, ObjectBuilder<SmoothingModel>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isLaplace() {
        return this._kind == Kind.Laplace;
    }

    public LaplaceSmoothingModel laplace() {
        return (LaplaceSmoothingModel)TaggedUnionUtils.get(this, Kind.Laplace);
    }

    public boolean isLinearInterpolation() {
        return this._kind == Kind.LinearInterpolation;
    }

    public LinearInterpolationSmoothingModel linearInterpolation() {
        return (LinearInterpolationSmoothingModel)TaggedUnionUtils.get(this, Kind.LinearInterpolation);
    }

    public boolean isStupidBackoff() {
        return this._kind == Kind.StupidBackoff;
    }

    public StupidBackoffSmoothingModel stupidBackoff() {
        return (StupidBackoffSmoothingModel)TaggedUnionUtils.get(this, Kind.StupidBackoff);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSmoothingModelDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::laplace, LaplaceSmoothingModel._DESERIALIZER, "laplace");
        op.add(Builder::linearInterpolation, LinearInterpolationSmoothingModel._DESERIALIZER, "linear_interpolation");
        op.add(Builder::stupidBackoff, StupidBackoffSmoothingModel._DESERIALIZER, "stupid_backoff");
    }

    public static enum Kind implements JsonEnum
    {
        Laplace("laplace"),
        LinearInterpolation("linear_interpolation"),
        StupidBackoff("stupid_backoff");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SmoothingModel> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<SmoothingModel> laplace(LaplaceSmoothingModel v) {
            this._kind = Kind.Laplace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SmoothingModel> laplace(Function<LaplaceSmoothingModel.Builder, ObjectBuilder<LaplaceSmoothingModel>> fn) {
            return this.laplace(fn.apply(new LaplaceSmoothingModel.Builder()).build());
        }

        public ObjectBuilder<SmoothingModel> linearInterpolation(LinearInterpolationSmoothingModel v) {
            this._kind = Kind.LinearInterpolation;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SmoothingModel> linearInterpolation(Function<LinearInterpolationSmoothingModel.Builder, ObjectBuilder<LinearInterpolationSmoothingModel>> fn) {
            return this.linearInterpolation(fn.apply(new LinearInterpolationSmoothingModel.Builder()).build());
        }

        public ObjectBuilder<SmoothingModel> stupidBackoff(StupidBackoffSmoothingModel v) {
            this._kind = Kind.StupidBackoff;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SmoothingModel> stupidBackoff(Function<StupidBackoffSmoothingModel.Builder, ObjectBuilder<StupidBackoffSmoothingModel>> fn) {
            return this.stupidBackoff(fn.apply(new StupidBackoffSmoothingModel.Builder()).build());
        }

        @Override
        public SmoothingModel build() {
            this._checkSingleUse();
            return new SmoothingModel(this);
        }
    }
}

