/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.DownsamplingRound;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class DataStreamLifecycleDownsampling
implements JsonpSerializable {
    private final List<DownsamplingRound> rounds;
    public static final JsonpDeserializer<DataStreamLifecycleDownsampling> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycleDownsampling::setupDataStreamLifecycleDownsamplingDeserializer);

    private DataStreamLifecycleDownsampling(Builder builder) {
        this.rounds = ApiTypeHelper.unmodifiableRequired(builder.rounds, (Object)this, "rounds");
    }

    public static DataStreamLifecycleDownsampling of(Function<Builder, ObjectBuilder<DataStreamLifecycleDownsampling>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DownsamplingRound> rounds() {
        return this.rounds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.rounds)) {
            generator.writeKey("rounds");
            generator.writeStartArray();
            for (DownsamplingRound item0 : this.rounds) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamLifecycleDownsamplingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rounds, JsonpDeserializer.arrayDeserializer(DownsamplingRound._DESERIALIZER), "rounds");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamLifecycleDownsampling> {
        private List<DownsamplingRound> rounds;

        public final Builder rounds(List<DownsamplingRound> list) {
            this.rounds = Builder._listAddAll(this.rounds, list);
            return this;
        }

        public final Builder rounds(DownsamplingRound value, DownsamplingRound ... values) {
            this.rounds = Builder._listAdd(this.rounds, value, values);
            return this;
        }

        public final Builder rounds(Function<DownsamplingRound.Builder, ObjectBuilder<DownsamplingRound>> fn) {
            return this.rounds(fn.apply(new DownsamplingRound.Builder()).build(), new DownsamplingRound[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycleDownsampling build() {
            this._checkSingleUse();
            return new DataStreamLifecycleDownsampling(this);
        }
    }
}

