/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.KeyedProcessor;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class IngestStats
implements JsonpSerializable {
    private final long count;
    private final long current;
    private final long failed;
    private final List<Map<String, KeyedProcessor>> processors;
    private final long timeInMillis;
    private final long ingestedAsFirstPipelineInBytes;
    private final long producedAsFirstPipelineInBytes;
    public static final JsonpDeserializer<IngestStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestStats::setupIngestStatsDeserializer);

    private IngestStats(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.processors = ApiTypeHelper.unmodifiableRequired(builder.processors, (Object)this, "processors");
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
        this.ingestedAsFirstPipelineInBytes = ApiTypeHelper.requireNonNull(builder.ingestedAsFirstPipelineInBytes, this, "ingestedAsFirstPipelineInBytes");
        this.producedAsFirstPipelineInBytes = ApiTypeHelper.requireNonNull(builder.producedAsFirstPipelineInBytes, this, "producedAsFirstPipelineInBytes");
    }

    public static IngestStats of(Function<Builder, ObjectBuilder<IngestStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long current() {
        return this.current;
    }

    public final long failed() {
        return this.failed;
    }

    public final List<Map<String, KeyedProcessor>> processors() {
        return this.processors;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    public final long ingestedAsFirstPipelineInBytes() {
        return this.ingestedAsFirstPipelineInBytes;
    }

    public final long producedAsFirstPipelineInBytes() {
        return this.producedAsFirstPipelineInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("current");
        generator.write(this.current);
        generator.writeKey("failed");
        generator.write(this.failed);
        if (ApiTypeHelper.isDefined(this.processors)) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Map<String, KeyedProcessor> item0 : this.processors) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, KeyedProcessor> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
        generator.writeKey("ingested_as_first_pipeline_in_bytes");
        generator.write(this.ingestedAsFirstPipelineInBytes);
        generator.writeKey("produced_as_first_pipeline_in_bytes");
        generator.write(this.producedAsFirstPipelineInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIngestStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(KeyedProcessor._DESERIALIZER)), "processors");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
        op.add(Builder::ingestedAsFirstPipelineInBytes, JsonpDeserializer.longDeserializer(), "ingested_as_first_pipeline_in_bytes");
        op.add(Builder::producedAsFirstPipelineInBytes, JsonpDeserializer.longDeserializer(), "produced_as_first_pipeline_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IngestStats> {
        private Long count;
        private Long current;
        private Long failed;
        private List<Map<String, KeyedProcessor>> processors;
        private Long timeInMillis;
        private Long ingestedAsFirstPipelineInBytes;
        private Long producedAsFirstPipelineInBytes;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder failed(long value) {
            this.failed = value;
            return this;
        }

        public final Builder processors(List<Map<String, KeyedProcessor>> list) {
            this.processors = Builder._listAddAll(this.processors, list);
            return this;
        }

        public final Builder processors(Map<String, KeyedProcessor> value, Map<String, KeyedProcessor> ... values) {
            this.processors = Builder._listAdd(this.processors, value, values);
            return this;
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        public final Builder ingestedAsFirstPipelineInBytes(long value) {
            this.ingestedAsFirstPipelineInBytes = value;
            return this;
        }

        public final Builder producedAsFirstPipelineInBytes(long value) {
            this.producedAsFirstPipelineInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IngestStats build() {
            this._checkSingleUse();
            return new IngestStats(this);
        }
    }
}

