/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GrantApiKeyResponse;
import co.elastic.clients.elasticsearch.security.grant_api_key.ApiKeyGrantType;
import co.elastic.clients.elasticsearch.security.grant_api_key.GrantApiKey;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GrantApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String accessToken;
    private final GrantApiKey apiKey;
    private final ApiKeyGrantType grantType;
    @Nullable
    private final String password;
    @Nullable
    private final String runAs;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<GrantApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrantApiKeyRequest::setupGrantApiKeyRequestDeserializer);
    public static final Endpoint<GrantApiKeyRequest, GrantApiKeyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GrantApiKeyRequest, GrantApiKeyResponse>("es/security.grant_api_key", request -> "POST", request -> "/_security/api_key/grant", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, GrantApiKeyResponse._DESERIALIZER);

    private GrantApiKeyRequest(Builder builder) {
        this.accessToken = builder.accessToken;
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.grantType = ApiTypeHelper.requireNonNull(builder.grantType, this, "grantType");
        this.password = builder.password;
        this.runAs = builder.runAs;
        this.username = builder.username;
    }

    public static GrantApiKeyRequest of(Function<Builder, ObjectBuilder<GrantApiKeyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String accessToken() {
        return this.accessToken;
    }

    public final GrantApiKey apiKey() {
        return this.apiKey;
    }

    public final ApiKeyGrantType grantType() {
        return this.grantType;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final String runAs() {
        return this.runAs;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.accessToken != null) {
            generator.writeKey("access_token");
            generator.write(this.accessToken);
        }
        generator.writeKey("api_key");
        this.apiKey.serialize(generator, mapper);
        generator.writeKey("grant_type");
        this.grantType.serialize(generator, mapper);
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.runAs != null) {
            generator.writeKey("run_as");
            generator.write(this.runAs);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    protected static void setupGrantApiKeyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::apiKey, GrantApiKey._DESERIALIZER, "api_key");
        op.add(Builder::grantType, ApiKeyGrantType._DESERIALIZER, "grant_type");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::runAs, JsonpDeserializer.stringDeserializer(), "run_as");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GrantApiKeyRequest> {
        @Nullable
        private String accessToken;
        private GrantApiKey apiKey;
        private ApiKeyGrantType grantType;
        @Nullable
        private String password;
        @Nullable
        private String runAs;
        @Nullable
        private String username;

        public final Builder accessToken(@Nullable String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder apiKey(GrantApiKey value) {
            this.apiKey = value;
            return this;
        }

        public final Builder apiKey(Function<GrantApiKey.Builder, ObjectBuilder<GrantApiKey>> fn) {
            return this.apiKey(fn.apply(new GrantApiKey.Builder()).build());
        }

        public final Builder grantType(ApiKeyGrantType value) {
            this.grantType = value;
            return this;
        }

        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public final Builder runAs(@Nullable String value) {
            this.runAs = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GrantApiKeyRequest build() {
            this._checkSingleUse();
            return new GrantApiKeyRequest(this);
        }
    }
}

