/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ClearCachedRealmsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ClearCachedRealmsRequest
extends RequestBase {
    private final List<String> realms;
    private final List<String> usernames;
    public static final Endpoint<ClearCachedRealmsRequest, ClearCachedRealmsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ClearCachedRealmsRequest, ClearCachedRealmsResponse>("es/security.clear_cached_realms", request -> "POST", request -> {
        boolean _realms = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/realm");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.realms.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_clear_cache");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.usernames)) {
            params.put("usernames", request.usernames.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ClearCachedRealmsResponse._DESERIALIZER);

    private ClearCachedRealmsRequest(Builder builder) {
        this.realms = ApiTypeHelper.unmodifiableRequired(builder.realms, (Object)this, "realms");
        this.usernames = ApiTypeHelper.unmodifiable(builder.usernames);
    }

    public static ClearCachedRealmsRequest of(Function<Builder, ObjectBuilder<ClearCachedRealmsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> realms() {
        return this.realms;
    }

    public final List<String> usernames() {
        return this.usernames;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ClearCachedRealmsRequest> {
        private List<String> realms;
        @Nullable
        private List<String> usernames;

        public final Builder realms(List<String> list) {
            this.realms = Builder._listAddAll(this.realms, list);
            return this;
        }

        public final Builder realms(String value, String ... values) {
            this.realms = Builder._listAdd(this.realms, value, values);
            return this;
        }

        public final Builder usernames(List<String> list) {
            this.usernames = Builder._listAddAll(this.usernames, list);
            return this;
        }

        public final Builder usernames(String value, String ... values) {
            this.usernames = Builder._listAdd(this.usernames, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClearCachedRealmsRequest build() {
            this._checkSingleUse();
            return new ClearCachedRealmsRequest(this);
        }
    }
}

