/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.has_privileges_user_profile;

import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.has_privileges.ApplicationPrivilegesCheck;
import co.elastic.clients.elasticsearch.security.has_privileges.IndexPrivilegesCheck;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PrivilegesCheck
implements JsonpSerializable {
    private final List<ApplicationPrivilegesCheck> application;
    private final List<ClusterPrivilege> cluster;
    private final List<IndexPrivilegesCheck> index;
    public static final JsonpDeserializer<PrivilegesCheck> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PrivilegesCheck::setupPrivilegesCheckDeserializer);

    private PrivilegesCheck(Builder builder) {
        this.application = ApiTypeHelper.unmodifiable(builder.application);
        this.cluster = ApiTypeHelper.unmodifiable(builder.cluster);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
    }

    public static PrivilegesCheck of(Function<Builder, ObjectBuilder<PrivilegesCheck>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ApplicationPrivilegesCheck> application() {
        return this.application;
    }

    public final List<ClusterPrivilege> cluster() {
        return this.cluster;
    }

    public final List<IndexPrivilegesCheck> index() {
        return this.index;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.application)) {
            generator.writeKey("application");
            generator.writeStartArray();
            for (ApplicationPrivilegesCheck applicationPrivilegesCheck : this.application) {
                applicationPrivilegesCheck.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (ClusterPrivilege clusterPrivilege : this.cluster) {
                clusterPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.index)) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (IndexPrivilegesCheck indexPrivilegesCheck : this.index) {
                indexPrivilegesCheck.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPrivilegesCheckDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::application, JsonpDeserializer.arrayDeserializer(ApplicationPrivilegesCheck._DESERIALIZER), "application");
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(ClusterPrivilege._DESERIALIZER), "cluster");
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(IndexPrivilegesCheck._DESERIALIZER), "index");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PrivilegesCheck> {
        @Nullable
        private List<ApplicationPrivilegesCheck> application;
        @Nullable
        private List<ClusterPrivilege> cluster;
        @Nullable
        private List<IndexPrivilegesCheck> index;

        public final Builder application(List<ApplicationPrivilegesCheck> list) {
            this.application = Builder._listAddAll(this.application, list);
            return this;
        }

        public final Builder application(ApplicationPrivilegesCheck value, ApplicationPrivilegesCheck ... values) {
            this.application = Builder._listAdd(this.application, value, values);
            return this;
        }

        public final Builder application(Function<ApplicationPrivilegesCheck.Builder, ObjectBuilder<ApplicationPrivilegesCheck>> fn) {
            return this.application(fn.apply(new ApplicationPrivilegesCheck.Builder()).build(), new ApplicationPrivilegesCheck[0]);
        }

        public final Builder cluster(List<ClusterPrivilege> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(ClusterPrivilege value, ClusterPrivilege ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder index(List<IndexPrivilegesCheck> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(IndexPrivilegesCheck value, IndexPrivilegesCheck ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder index(Function<IndexPrivilegesCheck.Builder, ObjectBuilder<IndexPrivilegesCheck>> fn) {
            return this.index(fn.apply(new IndexPrivilegesCheck.Builder()).build(), new IndexPrivilegesCheck[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PrivilegesCheck build() {
            this._checkSingleUse();
            return new PrivilegesCheck(this);
        }
    }
}

