/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TextIndexPrefixes
implements JsonpSerializable {
    private final int maxChars;
    private final int minChars;
    public static final JsonpDeserializer<TextIndexPrefixes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextIndexPrefixes::setupTextIndexPrefixesDeserializer);

    private TextIndexPrefixes(Builder builder) {
        this.maxChars = ApiTypeHelper.requireNonNull(builder.maxChars, this, "maxChars");
        this.minChars = ApiTypeHelper.requireNonNull(builder.minChars, this, "minChars");
    }

    public static TextIndexPrefixes of(Function<Builder, ObjectBuilder<TextIndexPrefixes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int maxChars() {
        return this.maxChars;
    }

    public final int minChars() {
        return this.minChars;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_chars");
        generator.write(this.maxChars);
        generator.writeKey("min_chars");
        generator.write(this.minChars);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextIndexPrefixesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxChars, JsonpDeserializer.integerDeserializer(), "max_chars");
        op.add(Builder::minChars, JsonpDeserializer.integerDeserializer(), "min_chars");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextIndexPrefixes> {
        private Integer maxChars;
        private Integer minChars;

        public final Builder maxChars(int value) {
            this.maxChars = value;
            return this;
        }

        public final Builder minChars(int value) {
            this.minChars = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextIndexPrefixes build() {
            this._checkSingleUse();
            return new TextIndexPrefixes(this);
        }
    }
}

