/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DeletePrivilegesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DeletePrivilegesRequest
extends RequestBase {
    private final String application;
    private final List<String> name;
    @Nullable
    private final Refresh refresh;
    public static final Endpoint<DeletePrivilegesRequest, DeletePrivilegesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeletePrivilegesRequest, DeletePrivilegesResponse>("es/security.delete_privileges", request -> "DELETE", request -> {
        boolean _application = true;
        int _name = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeletePrivilegesResponse._DESERIALIZER);

    private DeletePrivilegesRequest(Builder builder) {
        this.application = ApiTypeHelper.requireNonNull(builder.application, this, "application");
        this.name = ApiTypeHelper.unmodifiableRequired(builder.name, (Object)this, "name");
        this.refresh = builder.refresh;
    }

    public static DeletePrivilegesRequest of(Function<Builder, ObjectBuilder<DeletePrivilegesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String application() {
        return this.application;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DeletePrivilegesRequest> {
        private String application;
        private List<String> name;
        @Nullable
        private Refresh refresh;

        public final Builder application(String value) {
            this.application = value;
            return this;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        @Override
        public DeletePrivilegesRequest build() {
            this._checkSingleUse();
            return new DeletePrivilegesRequest(this);
        }
    }
}

