/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsHttpType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoSettingsHttp
implements JsonpSerializable {
    private final NodeInfoSettingsHttpType type;
    @Nullable
    private final String typeDefault;
    @Nullable
    private final Boolean compression;
    @Nullable
    private final String port;
    public static final JsonpDeserializer<NodeInfoSettingsHttp> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsHttp::setupNodeInfoSettingsHttpDeserializer);

    private NodeInfoSettingsHttp(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.typeDefault = builder.typeDefault;
        this.compression = builder.compression;
        this.port = builder.port;
    }

    public static NodeInfoSettingsHttp of(Function<Builder, ObjectBuilder<NodeInfoSettingsHttp>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeInfoSettingsHttpType type() {
        return this.type;
    }

    @Nullable
    public final String typeDefault() {
        return this.typeDefault;
    }

    @Nullable
    public final Boolean compression() {
        return this.compression;
    }

    @Nullable
    public final String port() {
        return this.port;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (this.typeDefault != null) {
            generator.writeKey("type.default");
            generator.write(this.typeDefault);
        }
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression.booleanValue());
        }
        if (this.port != null) {
            generator.writeKey("port");
            generator.write(this.port);
        }
    }

    protected static void setupNodeInfoSettingsHttpDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, NodeInfoSettingsHttpType._DESERIALIZER, "type");
        op.add(Builder::typeDefault, JsonpDeserializer.stringDeserializer(), "type.default");
        op.add(Builder::compression, JsonpDeserializer.booleanDeserializer(), "compression");
        op.add(Builder::port, JsonpDeserializer.stringDeserializer(), "port");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoSettingsHttp> {
        private NodeInfoSettingsHttpType type;
        @Nullable
        private String typeDefault;
        @Nullable
        private Boolean compression;
        @Nullable
        private String port;

        public final Builder type(NodeInfoSettingsHttpType value) {
            this.type = value;
            return this;
        }

        public final Builder type(Function<NodeInfoSettingsHttpType.Builder, ObjectBuilder<NodeInfoSettingsHttpType>> fn) {
            return this.type(fn.apply(new NodeInfoSettingsHttpType.Builder()).build());
        }

        public final Builder typeDefault(@Nullable String value) {
            this.typeDefault = value;
            return this;
        }

        public final Builder compression(@Nullable Boolean value) {
            this.compression = value;
            return this;
        }

        public final Builder port(@Nullable String value) {
            this.port = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoSettingsHttp build() {
            this._checkSingleUse();
            return new NodeInfoSettingsHttp(this);
        }
    }
}

