/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DeploymentAllocationState;
import co.elastic.clients.elasticsearch.ml.TrainedModelAllocationRoutingTable;
import co.elastic.clients.elasticsearch.ml.TrainedModelAllocationTaskParameters;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelAllocation
implements JsonpSerializable {
    private final DeploymentAllocationState allocationState;
    private final Map<String, TrainedModelAllocationRoutingTable> routingTable;
    private final DateTime startTime;
    private final TrainedModelAllocationTaskParameters taskParameters;
    public static final JsonpDeserializer<TrainedModelAllocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelAllocation::setupTrainedModelAllocationDeserializer);

    private TrainedModelAllocation(Builder builder) {
        this.allocationState = ApiTypeHelper.requireNonNull(builder.allocationState, this, "allocationState");
        this.routingTable = ApiTypeHelper.unmodifiableRequired(builder.routingTable, (Object)this, "routingTable");
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, this, "startTime");
        this.taskParameters = ApiTypeHelper.requireNonNull(builder.taskParameters, this, "taskParameters");
    }

    public static TrainedModelAllocation of(Function<Builder, ObjectBuilder<TrainedModelAllocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DeploymentAllocationState allocationState() {
        return this.allocationState;
    }

    public final Map<String, TrainedModelAllocationRoutingTable> routingTable() {
        return this.routingTable;
    }

    public final DateTime startTime() {
        return this.startTime;
    }

    public final TrainedModelAllocationTaskParameters taskParameters() {
        return this.taskParameters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocation_state");
        this.allocationState.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.routingTable)) {
            generator.writeKey("routing_table");
            generator.writeStartObject();
            for (Map.Entry<String, TrainedModelAllocationRoutingTable> item0 : this.routingTable.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("start_time");
        this.startTime.serialize(generator, mapper);
        generator.writeKey("task_parameters");
        this.taskParameters.serialize(generator, mapper);
    }

    protected static void setupTrainedModelAllocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocationState, DeploymentAllocationState._DESERIALIZER, "allocation_state");
        op.add(Builder::routingTable, JsonpDeserializer.stringMapDeserializer(TrainedModelAllocationRoutingTable._DESERIALIZER), "routing_table");
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time");
        op.add(Builder::taskParameters, TrainedModelAllocationTaskParameters._DESERIALIZER, "task_parameters");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelAllocation> {
        private DeploymentAllocationState allocationState;
        private Map<String, TrainedModelAllocationRoutingTable> routingTable;
        private DateTime startTime;
        private TrainedModelAllocationTaskParameters taskParameters;

        public final Builder allocationState(DeploymentAllocationState value) {
            this.allocationState = value;
            return this;
        }

        public final Builder routingTable(Map<String, TrainedModelAllocationRoutingTable> map) {
            this.routingTable = Builder._mapPutAll(this.routingTable, map);
            return this;
        }

        public final Builder routingTable(String key, TrainedModelAllocationRoutingTable value) {
            this.routingTable = Builder._mapPut(this.routingTable, key, value);
            return this;
        }

        public final Builder routingTable(String key, Function<TrainedModelAllocationRoutingTable.Builder, ObjectBuilder<TrainedModelAllocationRoutingTable>> fn) {
            return this.routingTable(key, fn.apply(new TrainedModelAllocationRoutingTable.Builder()).build());
        }

        public final Builder startTime(DateTime value) {
            this.startTime = value;
            return this;
        }

        public final Builder taskParameters(TrainedModelAllocationTaskParameters value) {
            this.taskParameters = value;
            return this;
        }

        public final Builder taskParameters(Function<TrainedModelAllocationTaskParameters.Builder, ObjectBuilder<TrainedModelAllocationTaskParameters>> fn) {
            return this.taskParameters(fn.apply(new TrainedModelAllocationTaskParameters.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelAllocation build() {
            this._checkSingleUse();
            return new TrainedModelAllocation(this);
        }
    }
}

