/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnalyzeToken
implements JsonpSerializable {
    private final long endOffset;
    private final long position;
    @Nullable
    private final Long positionLength;
    private final long startOffset;
    private final String token;
    private final String type;
    public static final JsonpDeserializer<AnalyzeToken> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeToken::setupAnalyzeTokenDeserializer);

    private AnalyzeToken(Builder builder) {
        this.endOffset = ApiTypeHelper.requireNonNull(builder.endOffset, this, "endOffset");
        this.position = ApiTypeHelper.requireNonNull(builder.position, this, "position");
        this.positionLength = builder.positionLength;
        this.startOffset = ApiTypeHelper.requireNonNull(builder.startOffset, this, "startOffset");
        this.token = ApiTypeHelper.requireNonNull(builder.token, this, "token");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static AnalyzeToken of(Function<Builder, ObjectBuilder<AnalyzeToken>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long endOffset() {
        return this.endOffset;
    }

    public final long position() {
        return this.position;
    }

    @Nullable
    public final Long positionLength() {
        return this.positionLength;
    }

    public final long startOffset() {
        return this.startOffset;
    }

    public final String token() {
        return this.token;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("end_offset");
        generator.write(this.endOffset);
        generator.writeKey("position");
        generator.write(this.position);
        if (this.positionLength != null) {
            generator.writeKey("position_length");
            generator.write(this.positionLength.longValue());
        }
        generator.writeKey("start_offset");
        generator.write(this.startOffset);
        generator.writeKey("token");
        generator.write(this.token);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupAnalyzeTokenDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endOffset, JsonpDeserializer.longDeserializer(), "end_offset");
        op.add(Builder::position, JsonpDeserializer.longDeserializer(), "position");
        op.add(Builder::positionLength, JsonpDeserializer.longDeserializer(), "position_length");
        op.add(Builder::startOffset, JsonpDeserializer.longDeserializer(), "start_offset");
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnalyzeToken> {
        private Long endOffset;
        private Long position;
        @Nullable
        private Long positionLength;
        private Long startOffset;
        private String token;
        private String type;

        public final Builder endOffset(long value) {
            this.endOffset = value;
            return this;
        }

        public final Builder position(long value) {
            this.position = value;
            return this;
        }

        public final Builder positionLength(@Nullable Long value) {
            this.positionLength = value;
            return this;
        }

        public final Builder startOffset(long value) {
            this.startOffset = value;
            return this;
        }

        public final Builder token(String value) {
            this.token = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnalyzeToken build() {
            this._checkSingleUse();
            return new AnalyzeToken(this);
        }
    }
}

