/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.explain;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExplanationDetail
implements JsonpSerializable {
    private final String description;
    private final List<ExplanationDetail> details;
    private final float value;
    public static final JsonpDeserializer<ExplanationDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExplanationDetail::setupExplanationDetailDeserializer);

    private ExplanationDetail(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.details = ApiTypeHelper.unmodifiable(builder.details);
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value").floatValue();
    }

    public static ExplanationDetail of(Function<Builder, ObjectBuilder<ExplanationDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final List<ExplanationDetail> details() {
        return this.details;
    }

    public final float value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (ExplanationDetail item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("value");
        generator.write((double)this.value);
    }

    protected static void setupExplanationDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "details");
        op.add(Builder::value, JsonpDeserializer.floatDeserializer(), "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExplanationDetail> {
        private String description;
        @Nullable
        private List<ExplanationDetail> details;
        private Float value;

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder details(List<ExplanationDetail> list) {
            this.details = Builder._listAddAll(this.details, list);
            return this;
        }

        public final Builder details(ExplanationDetail value, ExplanationDetail ... values) {
            this.details = Builder._listAdd(this.details, value, values);
            return this;
        }

        public final Builder details(Function<Builder, ObjectBuilder<ExplanationDetail>> fn) {
            return this.details(fn.apply(new Builder()).build(), new ExplanationDetail[0]);
        }

        public final Builder value(float value) {
            this.value = Float.valueOf(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExplanationDetail build() {
            this._checkSingleUse();
            return new ExplanationDetail(this);
        }
    }
}

