/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.async_search.GetAsyncSearchResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetAsyncSearchRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final Time keepAlive;
    @Nullable
    private final Time waitForCompletionTimeout;
    public static final SimpleEndpoint<GetAsyncSearchRequest, ?> _ENDPOINT = new SimpleEndpoint<GetAsyncSearchRequest, GetAsyncSearchResponse<Object>>("es/async_search.get", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_async_search");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typed_keys", "true");
        if (request.keepAlive != null) {
            params.put("keep_alive", request.keepAlive._toJsonString());
        }
        if (request.waitForCompletionTimeout != null) {
            params.put("wait_for_completion_timeout", request.waitForCompletionTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetAsyncSearchResponse._DESERIALIZER);

    private GetAsyncSearchRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.keepAlive = builder.keepAlive;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public static GetAsyncSearchRequest of(Function<Builder, ObjectBuilder<GetAsyncSearchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Time waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static <TDocument> Endpoint<GetAsyncSearchRequest, GetAsyncSearchResponse<TDocument>, ErrorResponse> createGetEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(GetAsyncSearchResponse.createGetAsyncSearchResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetAsyncSearchRequest> {
        private String id;
        @Nullable
        private Time keepAlive;
        @Nullable
        private Time waitForCompletionTimeout;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForCompletionTimeout(@Nullable Time value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitForCompletionTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public GetAsyncSearchRequest build() {
            this._checkSingleUse();
            return new GetAsyncSearchRequest(this);
        }
    }
}

