/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteJobResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteJobRequest
extends RequestBase {
    @Nullable
    private final Boolean deleteUserAnnotations;
    @Nullable
    private final Boolean force;
    private final String jobId;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<DeleteJobRequest, DeleteJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteJobRequest, DeleteJobResponse>("es/ml.delete_job", request -> "DELETE", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("jobId", request.jobId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.deleteUserAnnotations != null) {
            params.put("delete_user_annotations", String.valueOf(request.deleteUserAnnotations));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteJobResponse._DESERIALIZER);

    private DeleteJobRequest(Builder builder) {
        this.deleteUserAnnotations = builder.deleteUserAnnotations;
        this.force = builder.force;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static DeleteJobRequest of(Function<Builder, ObjectBuilder<DeleteJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean deleteUserAnnotations() {
        return this.deleteUserAnnotations;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteJobRequest> {
        @Nullable
        private Boolean deleteUserAnnotations;
        @Nullable
        private Boolean force;
        private String jobId;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder deleteUserAnnotations(@Nullable Boolean value) {
            this.deleteUserAnnotations = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteJobRequest build() {
            this._checkSingleUse();
            return new DeleteJobRequest(this);
        }
    }
}

