/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PassthroughObjectProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Integer priority;
    @Nullable
    private final Boolean timeSeriesDimension;
    public static final JsonpDeserializer<PassthroughObjectProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PassthroughObjectProperty::setupPassthroughObjectPropertyDeserializer);

    private PassthroughObjectProperty(Builder builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.priority = builder.priority;
        this.timeSeriesDimension = builder.timeSeriesDimension;
    }

    public static PassthroughObjectProperty of(Function<Builder, ObjectBuilder<PassthroughObjectProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Passthrough;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Integer priority() {
        return this.priority;
    }

    @Nullable
    public final Boolean timeSeriesDimension() {
        return this.timeSeriesDimension;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "passthrough");
        super.serializeInternal(generator, mapper);
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.intValue());
        }
        if (this.timeSeriesDimension != null) {
            generator.writeKey("time_series_dimension");
            generator.write(this.timeSeriesDimension.booleanValue());
        }
    }

    protected static void setupPassthroughObjectPropertyDeserializer(ObjectDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::priority, JsonpDeserializer.integerDeserializer(), "priority");
        op.add(Builder::timeSeriesDimension, JsonpDeserializer.booleanDeserializer(), "time_series_dimension");
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PassthroughObjectProperty> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Integer priority;
        @Nullable
        private Boolean timeSeriesDimension;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder priority(@Nullable Integer value) {
            this.priority = value;
            return this;
        }

        public final Builder timeSeriesDimension(@Nullable Boolean value) {
            this.timeSeriesDimension = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PassthroughObjectProperty build() {
            this._checkSingleUse();
            return new PassthroughObjectProperty(this);
        }
    }
}

