/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.ConnectorConfigProperties;
import co.elastic.clients.elasticsearch.connector.UpdateConfigurationResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateConfigurationRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, ConnectorConfigProperties> configuration;
    private final String connectorId;
    private final Map<String, JsonData> values;
    public static final JsonpDeserializer<UpdateConfigurationRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateConfigurationRequest::setupUpdateConfigurationRequestDeserializer);
    public static final Endpoint<UpdateConfigurationRequest, UpdateConfigurationResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateConfigurationRequest, UpdateConfigurationResponse>("es/connector.update_configuration", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_configuration");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateConfigurationResponse._DESERIALIZER);

    private UpdateConfigurationRequest(Builder builder) {
        this.configuration = ApiTypeHelper.unmodifiable(builder.configuration);
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.values = ApiTypeHelper.unmodifiable(builder.values);
    }

    public static UpdateConfigurationRequest of(Function<Builder, ObjectBuilder<UpdateConfigurationRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ConnectorConfigProperties> configuration() {
        return this.configuration;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final Map<String, JsonData> values() {
        return this.values;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.configuration)) {
            generator.writeKey("configuration");
            generator.writeStartObject();
            for (Map.Entry<String, ConnectorConfigProperties> entry : this.configuration.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.values)) {
            generator.writeKey("values");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.values.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateConfigurationRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::configuration, JsonpDeserializer.stringMapDeserializer(ConnectorConfigProperties._DESERIALIZER), "configuration");
        op.add(Builder::values, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "values");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateConfigurationRequest> {
        @Nullable
        private Map<String, ConnectorConfigProperties> configuration;
        private String connectorId;
        @Nullable
        private Map<String, JsonData> values;

        public final Builder configuration(Map<String, ConnectorConfigProperties> map) {
            this.configuration = Builder._mapPutAll(this.configuration, map);
            return this;
        }

        public final Builder configuration(String key, ConnectorConfigProperties value) {
            this.configuration = Builder._mapPut(this.configuration, key, value);
            return this;
        }

        public final Builder configuration(String key, Function<ConnectorConfigProperties.Builder, ObjectBuilder<ConnectorConfigProperties>> fn) {
            return this.configuration(key, fn.apply(new ConnectorConfigProperties.Builder()).build());
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder values(Map<String, JsonData> map) {
            this.values = Builder._mapPutAll(this.values, map);
            return this;
        }

        public final Builder values(String key, JsonData value) {
            this.values = Builder._mapPut(this.values, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateConfigurationRequest build() {
            this._checkSingleUse();
            return new UpdateConfigurationRequest(this);
        }
    }
}

