/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.lang.Long;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: snapshot._types.SnapshotStats

/**
 *
 * @see <a href="../doc-files/api-spec.html#snapshot._types.SnapshotStats">API
 *      specification</a>
 */
@JsonpDeserializable
public class SnapshotStats implements JsonpSerializable {
	private final FileCountSnapshotStats incremental;

	private final long startTimeInMillis;

	@Nullable
	private final Time time;

	private final long timeInMillis;

	private final FileCountSnapshotStats total;

	// ---------------------------------------------------------------------------------------------

	private SnapshotStats(Builder builder) {

		this.incremental = ApiTypeHelper.requireNonNull(builder.incremental, this, "incremental");
		this.startTimeInMillis = ApiTypeHelper.requireNonNull(builder.startTimeInMillis, this, "startTimeInMillis", 0);
		this.time = builder.time;
		this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis", 0);
		this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");

	}

	public static SnapshotStats of(Function<Builder, ObjectBuilder<SnapshotStats>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Required - The number and size of files that still need to be copied as part
	 * of the incremental snapshot. For completed snapshots, this property indicates
	 * the number and size of files that were not already in the repository and were
	 * copied as part of the incremental snapshot.
	 * <p>
	 * API name: {@code incremental}
	 */
	public final FileCountSnapshotStats incremental() {
		return this.incremental;
	}

	/**
	 * Required - The time, in milliseconds, when the snapshot creation process
	 * started.
	 * <p>
	 * API name: {@code start_time_in_millis}
	 */
	public final long startTimeInMillis() {
		return this.startTimeInMillis;
	}

	/**
	 * API name: {@code time}
	 */
	@Nullable
	public final Time time() {
		return this.time;
	}

	/**
	 * Required - The total time, in milliseconds, that it took for the snapshot
	 * process to complete.
	 * <p>
	 * API name: {@code time_in_millis}
	 */
	public final long timeInMillis() {
		return this.timeInMillis;
	}

	/**
	 * Required - The total number and size of files that are referenced by the
	 * snapshot.
	 * <p>
	 * API name: {@code total}
	 */
	public final FileCountSnapshotStats total() {
		return this.total;
	}

	/**
	 * Serialize this object to JSON.
	 */
	public void serialize(JsonGenerator generator, JsonpMapper mapper) {
		generator.writeStartObject();
		serializeInternal(generator, mapper);
		generator.writeEnd();
	}

	protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

		generator.writeKey("incremental");
		this.incremental.serialize(generator, mapper);

		generator.writeKey("start_time_in_millis");
		generator.write(this.startTimeInMillis);

		if (this.time != null) {
			generator.writeKey("time");
			this.time.serialize(generator, mapper);

		}
		generator.writeKey("time_in_millis");
		generator.write(this.timeInMillis);

		generator.writeKey("total");
		this.total.serialize(generator, mapper);

	}

	@Override
	public String toString() {
		return JsonpUtils.toString(this);
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link SnapshotStats}.
	 */

	public static class Builder extends WithJsonObjectBuilderBase<Builder> implements ObjectBuilder<SnapshotStats> {
		private FileCountSnapshotStats incremental;

		private Long startTimeInMillis;

		@Nullable
		private Time time;

		private Long timeInMillis;

		private FileCountSnapshotStats total;

		/**
		 * Required - The number and size of files that still need to be copied as part
		 * of the incremental snapshot. For completed snapshots, this property indicates
		 * the number and size of files that were not already in the repository and were
		 * copied as part of the incremental snapshot.
		 * <p>
		 * API name: {@code incremental}
		 */
		public final Builder incremental(FileCountSnapshotStats value) {
			this.incremental = value;
			return this;
		}

		/**
		 * Required - The number and size of files that still need to be copied as part
		 * of the incremental snapshot. For completed snapshots, this property indicates
		 * the number and size of files that were not already in the repository and were
		 * copied as part of the incremental snapshot.
		 * <p>
		 * API name: {@code incremental}
		 */
		public final Builder incremental(
				Function<FileCountSnapshotStats.Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
			return this.incremental(fn.apply(new FileCountSnapshotStats.Builder()).build());
		}

		/**
		 * Required - The time, in milliseconds, when the snapshot creation process
		 * started.
		 * <p>
		 * API name: {@code start_time_in_millis}
		 */
		public final Builder startTimeInMillis(long value) {
			this.startTimeInMillis = value;
			return this;
		}

		/**
		 * API name: {@code time}
		 */
		public final Builder time(@Nullable Time value) {
			this.time = value;
			return this;
		}

		/**
		 * API name: {@code time}
		 */
		public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
			return this.time(fn.apply(new Time.Builder()).build());
		}

		/**
		 * Required - The total time, in milliseconds, that it took for the snapshot
		 * process to complete.
		 * <p>
		 * API name: {@code time_in_millis}
		 */
		public final Builder timeInMillis(long value) {
			this.timeInMillis = value;
			return this;
		}

		/**
		 * Required - The total number and size of files that are referenced by the
		 * snapshot.
		 * <p>
		 * API name: {@code total}
		 */
		public final Builder total(FileCountSnapshotStats value) {
			this.total = value;
			return this;
		}

		/**
		 * Required - The total number and size of files that are referenced by the
		 * snapshot.
		 * <p>
		 * API name: {@code total}
		 */
		public final Builder total(Function<FileCountSnapshotStats.Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
			return this.total(fn.apply(new FileCountSnapshotStats.Builder()).build());
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link SnapshotStats}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public SnapshotStats build() {
			_checkSingleUse();

			return new SnapshotStats(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link SnapshotStats}
	 */
	public static final JsonpDeserializer<SnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new,
			SnapshotStats::setupSnapshotStatsDeserializer);

	protected static void setupSnapshotStatsDeserializer(ObjectDeserializer<SnapshotStats.Builder> op) {

		op.add(Builder::incremental, FileCountSnapshotStats._DESERIALIZER, "incremental");
		op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis");
		op.add(Builder::time, Time._DESERIALIZER, "time");
		op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
		op.add(Builder::total, FileCountSnapshotStats._DESERIALIZER, "total");

	}

}
