/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.query_rules.PutRulesetResponse;
import co.elastic.clients.elasticsearch.query_rules.QueryRule;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PutRulesetRequest
extends RequestBase
implements JsonpSerializable {
    private final List<QueryRule> rules;
    private final String rulesetId;
    public static final JsonpDeserializer<PutRulesetRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRulesetRequest::setupPutRulesetRequestDeserializer);
    public static final Endpoint<PutRulesetRequest, PutRulesetResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRulesetRequest, PutRulesetResponse>("es/query_rules.put_ruleset", request -> "PUT", request -> {
        boolean _rulesetId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_query_rules");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.rulesetId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _rulesetId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("rulesetId", request.rulesetId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutRulesetResponse._DESERIALIZER);

    private PutRulesetRequest(Builder builder) {
        this.rules = ApiTypeHelper.unmodifiableRequired(builder.rules, (Object)this, "rules");
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
    }

    public static PutRulesetRequest of(Function<Builder, ObjectBuilder<PutRulesetRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<QueryRule> rules() {
        return this.rules;
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.rules)) {
            generator.writeKey("rules");
            generator.writeStartArray();
            for (QueryRule item0 : this.rules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutRulesetRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rules, JsonpDeserializer.arrayDeserializer(QueryRule._DESERIALIZER), "rules");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRulesetRequest> {
        private List<QueryRule> rules;
        private String rulesetId;

        public final Builder rules(List<QueryRule> list) {
            this.rules = Builder._listAddAll(this.rules, list);
            return this;
        }

        public final Builder rules(QueryRule value, QueryRule ... values) {
            this.rules = Builder._listAdd(this.rules, value, values);
            return this;
        }

        public final Builder rules(Function<QueryRule.Builder, ObjectBuilder<QueryRule>> fn) {
            return this.rules(fn.apply(new QueryRule.Builder()).build(), new QueryRule[0]);
        }

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRulesetRequest build() {
            this._checkSingleUse();
            return new PutRulesetRequest(this);
        }
    }
}

