/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.ConnectorFeatures;
import co.elastic.clients.elasticsearch.connector.UpdateFeaturesResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateFeaturesRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final ConnectorFeatures features;
    public static final JsonpDeserializer<UpdateFeaturesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateFeaturesRequest::setupUpdateFeaturesRequestDeserializer);
    public static final Endpoint<UpdateFeaturesRequest, UpdateFeaturesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateFeaturesRequest, UpdateFeaturesResponse>("es/connector.update_features", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_features");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateFeaturesResponse._DESERIALIZER);

    private UpdateFeaturesRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.features = ApiTypeHelper.requireNonNull(builder.features, this, "features");
    }

    public static UpdateFeaturesRequest of(Function<Builder, ObjectBuilder<UpdateFeaturesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final ConnectorFeatures features() {
        return this.features;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("features");
        this.features.serialize(generator, mapper);
    }

    protected static void setupUpdateFeaturesRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::features, ConnectorFeatures._DESERIALIZER, "features");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateFeaturesRequest> {
        private String connectorId;
        private ConnectorFeatures features;

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder features(ConnectorFeatures value) {
            this.features = value;
            return this;
        }

        public final Builder features(Function<ConnectorFeatures.Builder, ObjectBuilder<ConnectorFeatures>> fn) {
            return this.features(fn.apply(new ConnectorFeatures.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateFeaturesRequest build() {
            this._checkSingleUse();
            return new UpdateFeaturesRequest(this);
        }
    }
}

