/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.UserProfileWithMetadata;
import co.elastic.clients.elasticsearch.security.get_user_profile.GetUserProfileErrors;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetUserProfileResponse
implements JsonpSerializable {
    private final List<UserProfileWithMetadata> profiles;
    @Nullable
    private final GetUserProfileErrors errors;
    public static final JsonpDeserializer<GetUserProfileResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetUserProfileResponse::setupGetUserProfileResponseDeserializer);

    private GetUserProfileResponse(Builder builder) {
        this.profiles = ApiTypeHelper.unmodifiableRequired(builder.profiles, (Object)this, "profiles");
        this.errors = builder.errors;
    }

    public static GetUserProfileResponse of(Function<Builder, ObjectBuilder<GetUserProfileResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<UserProfileWithMetadata> profiles() {
        return this.profiles;
    }

    @Nullable
    public final GetUserProfileErrors errors() {
        return this.errors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.profiles)) {
            generator.writeKey("profiles");
            generator.writeStartArray();
            for (UserProfileWithMetadata item0 : this.profiles) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.errors != null) {
            generator.writeKey("errors");
            this.errors.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetUserProfileResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::profiles, JsonpDeserializer.arrayDeserializer(UserProfileWithMetadata._DESERIALIZER), "profiles");
        op.add(Builder::errors, GetUserProfileErrors._DESERIALIZER, "errors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetUserProfileResponse> {
        private List<UserProfileWithMetadata> profiles;
        @Nullable
        private GetUserProfileErrors errors;

        public final Builder profiles(List<UserProfileWithMetadata> list) {
            this.profiles = Builder._listAddAll(this.profiles, list);
            return this;
        }

        public final Builder profiles(UserProfileWithMetadata value, UserProfileWithMetadata ... values) {
            this.profiles = Builder._listAdd(this.profiles, value, values);
            return this;
        }

        public final Builder profiles(Function<UserProfileWithMetadata.Builder, ObjectBuilder<UserProfileWithMetadata>> fn) {
            return this.profiles(fn.apply(new UserProfileWithMetadata.Builder()).build(), new UserProfileWithMetadata[0]);
        }

        public final Builder errors(@Nullable GetUserProfileErrors value) {
            this.errors = value;
            return this;
        }

        public final Builder errors(Function<GetUserProfileErrors.Builder, ObjectBuilder<GetUserProfileErrors>> fn) {
            return this.errors(fn.apply(new GetUserProfileErrors.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetUserProfileResponse build() {
            this._checkSingleUse();
            return new GetUserProfileResponse(this);
        }
    }
}

