/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.ConnectorConfigProperties;
import co.elastic.clients.elasticsearch.connector.FilteringRules;
import co.elastic.clients.elasticsearch.connector.IngestPipelineParams;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SyncJobConnectorReference
implements JsonpSerializable {
    private final Map<String, ConnectorConfigProperties> configuration;
    private final FilteringRules filtering;
    private final String id;
    private final String indexName;
    @Nullable
    private final String language;
    @Nullable
    private final IngestPipelineParams pipeline;
    private final String serviceType;
    @Nullable
    private final JsonData syncCursor;
    public static final JsonpDeserializer<SyncJobConnectorReference> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SyncJobConnectorReference::setupSyncJobConnectorReferenceDeserializer);

    private SyncJobConnectorReference(Builder builder) {
        this.configuration = ApiTypeHelper.unmodifiableRequired(builder.configuration, (Object)this, "configuration");
        this.filtering = ApiTypeHelper.requireNonNull(builder.filtering, this, "filtering");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.indexName = ApiTypeHelper.requireNonNull(builder.indexName, this, "indexName");
        this.language = builder.language;
        this.pipeline = builder.pipeline;
        this.serviceType = ApiTypeHelper.requireNonNull(builder.serviceType, this, "serviceType");
        this.syncCursor = builder.syncCursor;
    }

    public static SyncJobConnectorReference of(Function<Builder, ObjectBuilder<SyncJobConnectorReference>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ConnectorConfigProperties> configuration() {
        return this.configuration;
    }

    public final FilteringRules filtering() {
        return this.filtering;
    }

    public final String id() {
        return this.id;
    }

    public final String indexName() {
        return this.indexName;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Nullable
    public final IngestPipelineParams pipeline() {
        return this.pipeline;
    }

    public final String serviceType() {
        return this.serviceType;
    }

    @Nullable
    public final JsonData syncCursor() {
        return this.syncCursor;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.configuration)) {
            generator.writeKey("configuration");
            generator.writeStartObject();
            for (Map.Entry<String, ConnectorConfigProperties> item0 : this.configuration.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("filtering");
        this.filtering.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index_name");
        generator.write(this.indexName);
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            this.pipeline.serialize(generator, mapper);
        }
        generator.writeKey("service_type");
        generator.write(this.serviceType);
        if (this.syncCursor != null) {
            generator.writeKey("sync_cursor");
            this.syncCursor.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSyncJobConnectorReferenceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::configuration, JsonpDeserializer.stringMapDeserializer(ConnectorConfigProperties._DESERIALIZER), "configuration");
        op.add(Builder::filtering, FilteringRules._DESERIALIZER, "filtering");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(Builder::pipeline, IngestPipelineParams._DESERIALIZER, "pipeline");
        op.add(Builder::serviceType, JsonpDeserializer.stringDeserializer(), "service_type");
        op.add(Builder::syncCursor, JsonData._DESERIALIZER, "sync_cursor");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SyncJobConnectorReference> {
        private Map<String, ConnectorConfigProperties> configuration;
        private FilteringRules filtering;
        private String id;
        private String indexName;
        @Nullable
        private String language;
        @Nullable
        private IngestPipelineParams pipeline;
        private String serviceType;
        @Nullable
        private JsonData syncCursor;

        public final Builder configuration(Map<String, ConnectorConfigProperties> map) {
            this.configuration = Builder._mapPutAll(this.configuration, map);
            return this;
        }

        public final Builder configuration(String key, ConnectorConfigProperties value) {
            this.configuration = Builder._mapPut(this.configuration, key, value);
            return this;
        }

        public final Builder configuration(String key, Function<ConnectorConfigProperties.Builder, ObjectBuilder<ConnectorConfigProperties>> fn) {
            return this.configuration(key, fn.apply(new ConnectorConfigProperties.Builder()).build());
        }

        public final Builder filtering(FilteringRules value) {
            this.filtering = value;
            return this;
        }

        public final Builder filtering(Function<FilteringRules.Builder, ObjectBuilder<FilteringRules>> fn) {
            return this.filtering(fn.apply(new FilteringRules.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        public final Builder pipeline(@Nullable IngestPipelineParams value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipeline(Function<IngestPipelineParams.Builder, ObjectBuilder<IngestPipelineParams>> fn) {
            return this.pipeline(fn.apply(new IngestPipelineParams.Builder()).build());
        }

        public final Builder serviceType(String value) {
            this.serviceType = value;
            return this;
        }

        public final Builder syncCursor(@Nullable JsonData value) {
            this.syncCursor = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SyncJobConnectorReference build() {
            this._checkSingleUse();
            return new SyncJobConnectorReference(this);
        }
    }
}

