/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Counter;
import co.elastic.clients.elasticsearch.xpack.usage.WatcherWatchTrigger;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WatcherWatch
implements JsonpSerializable {
    private final Map<String, Counter> input;
    private final Map<String, Counter> condition;
    private final Map<String, Counter> action;
    private final WatcherWatchTrigger trigger;
    public static final JsonpDeserializer<WatcherWatch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherWatch::setupWatcherWatchDeserializer);

    private WatcherWatch(Builder builder) {
        this.input = ApiTypeHelper.unmodifiableRequired(builder.input, (Object)this, "input");
        this.condition = ApiTypeHelper.unmodifiable(builder.condition);
        this.action = ApiTypeHelper.unmodifiable(builder.action);
        this.trigger = ApiTypeHelper.requireNonNull(builder.trigger, this, "trigger");
    }

    public static WatcherWatch of(Function<Builder, ObjectBuilder<WatcherWatch>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Counter> input() {
        return this.input;
    }

    public final Map<String, Counter> condition() {
        return this.condition;
    }

    public final Map<String, Counter> action() {
        return this.action;
    }

    public final WatcherWatchTrigger trigger() {
        return this.trigger;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.input)) {
            generator.writeKey("input");
            generator.writeStartObject();
            for (Map.Entry<String, Counter> item0 : this.input.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.condition)) {
            generator.writeKey("condition");
            generator.writeStartObject();
            for (Map.Entry<String, Counter> item0 : this.condition.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.action)) {
            generator.writeKey("action");
            generator.writeStartObject();
            for (Map.Entry<String, Counter> item0 : this.action.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("trigger");
        this.trigger.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWatcherWatchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::input, JsonpDeserializer.stringMapDeserializer(Counter._DESERIALIZER), "input");
        op.add(Builder::condition, JsonpDeserializer.stringMapDeserializer(Counter._DESERIALIZER), "condition");
        op.add(Builder::action, JsonpDeserializer.stringMapDeserializer(Counter._DESERIALIZER), "action");
        op.add(Builder::trigger, WatcherWatchTrigger._DESERIALIZER, "trigger");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatcherWatch> {
        private Map<String, Counter> input;
        @Nullable
        private Map<String, Counter> condition;
        @Nullable
        private Map<String, Counter> action;
        private WatcherWatchTrigger trigger;

        public Builder() {
        }

        private Builder(WatcherWatch instance) {
            this.input = instance.input;
            this.condition = instance.condition;
            this.action = instance.action;
            this.trigger = instance.trigger;
        }

        public final Builder input(Map<String, Counter> map) {
            this.input = Builder._mapPutAll(this.input, map);
            return this;
        }

        public final Builder input(String key, Counter value) {
            this.input = Builder._mapPut(this.input, key, value);
            return this;
        }

        public final Builder input(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.input(key, fn.apply(new Counter.Builder()).build());
        }

        public final Builder condition(Map<String, Counter> map) {
            this.condition = Builder._mapPutAll(this.condition, map);
            return this;
        }

        public final Builder condition(String key, Counter value) {
            this.condition = Builder._mapPut(this.condition, key, value);
            return this;
        }

        public final Builder condition(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.condition(key, fn.apply(new Counter.Builder()).build());
        }

        public final Builder action(Map<String, Counter> map) {
            this.action = Builder._mapPutAll(this.action, map);
            return this;
        }

        public final Builder action(String key, Counter value) {
            this.action = Builder._mapPut(this.action, key, value);
            return this;
        }

        public final Builder action(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.action(key, fn.apply(new Counter.Builder()).build());
        }

        public final Builder trigger(WatcherWatchTrigger value) {
            this.trigger = value;
            return this;
        }

        public final Builder trigger(Function<WatcherWatchTrigger.Builder, ObjectBuilder<WatcherWatchTrigger>> fn) {
            return this.trigger(fn.apply(new WatcherWatchTrigger.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatcherWatch build() {
            this._checkSingleUse();
            return new WatcherWatch(this);
        }
    }
}

