/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SecurityRolesDlsBitSetCache
implements JsonpSerializable {
    private final int count;
    @Nullable
    private final String memory;
    private final Number memoryInBytes;
    public static final JsonpDeserializer<SecurityRolesDlsBitSetCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SecurityRolesDlsBitSetCache::setupSecurityRolesDlsBitSetCacheDeserializer);

    private SecurityRolesDlsBitSetCache(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.memory = builder.memory;
        this.memoryInBytes = ApiTypeHelper.requireNonNull(builder.memoryInBytes, this, "memoryInBytes");
    }

    public static SecurityRolesDlsBitSetCache of(Function<Builder, ObjectBuilder<SecurityRolesDlsBitSetCache>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    @Nullable
    public final String memory() {
        return this.memory;
    }

    public final Number memoryInBytes() {
        return this.memoryInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.memory != null) {
            generator.writeKey("memory");
            generator.write(this.memory);
        }
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes.doubleValue());
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSecurityRolesDlsBitSetCacheDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::memory, JsonpDeserializer.stringDeserializer(), "memory");
        op.add(Builder::memoryInBytes, JsonpDeserializer.numberDeserializer(), "memory_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SecurityRolesDlsBitSetCache> {
        private Integer count;
        @Nullable
        private String memory;
        private Number memoryInBytes;

        public Builder() {
        }

        private Builder(SecurityRolesDlsBitSetCache instance) {
            this.count = instance.count;
            this.memory = instance.memory;
            this.memoryInBytes = instance.memoryInBytes;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder memory(@Nullable String value) {
            this.memory = value;
            return this;
        }

        public final Builder memoryInBytes(Number value) {
            this.memoryInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SecurityRolesDlsBitSetCache build() {
            this._checkSingleUse();
            return new SecurityRolesDlsBitSetCache(this);
        }
    }
}

