/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.Datafeed;
import co.elastic.clients.elasticsearch.xpack.usage.JobUsage;
import co.elastic.clients.elasticsearch.xpack.usage.MlDataFrameAnalyticsJobs;
import co.elastic.clients.elasticsearch.xpack.usage.MlInference;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class MachineLearning
extends Base {
    private final Map<String, Datafeed> datafeeds;
    private final Map<String, JobUsage> jobs;
    private final int nodeCount;
    private final MlDataFrameAnalyticsJobs dataFrameAnalyticsJobs;
    private final MlInference inference;
    public static final JsonpDeserializer<MachineLearning> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MachineLearning::setupMachineLearningDeserializer);

    private MachineLearning(Builder builder) {
        super(builder);
        this.datafeeds = ApiTypeHelper.unmodifiableRequired(builder.datafeeds, (Object)this, "datafeeds");
        this.jobs = ApiTypeHelper.unmodifiableRequired(builder.jobs, (Object)this, "jobs");
        this.nodeCount = ApiTypeHelper.requireNonNull(builder.nodeCount, (Object)this, "nodeCount", 0);
        this.dataFrameAnalyticsJobs = ApiTypeHelper.requireNonNull(builder.dataFrameAnalyticsJobs, this, "dataFrameAnalyticsJobs");
        this.inference = ApiTypeHelper.requireNonNull(builder.inference, this, "inference");
    }

    public static MachineLearning of(Function<Builder, ObjectBuilder<MachineLearning>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Datafeed> datafeeds() {
        return this.datafeeds;
    }

    public final Map<String, JobUsage> jobs() {
        return this.jobs;
    }

    public final int nodeCount() {
        return this.nodeCount;
    }

    public final MlDataFrameAnalyticsJobs dataFrameAnalyticsJobs() {
        return this.dataFrameAnalyticsJobs;
    }

    public final MlInference inference() {
        return this.inference;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.datafeeds)) {
            generator.writeKey("datafeeds");
            generator.writeStartObject();
            for (Map.Entry<String, Datafeed> entry : this.datafeeds.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.jobs)) {
            generator.writeKey("jobs");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.jobs.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JobUsage)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("node_count");
        generator.write(this.nodeCount);
        generator.writeKey("data_frame_analytics_jobs");
        this.dataFrameAnalyticsJobs.serialize(generator, mapper);
        generator.writeKey("inference");
        this.inference.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMachineLearningDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::datafeeds, JsonpDeserializer.stringMapDeserializer(Datafeed._DESERIALIZER), "datafeeds");
        op.add(Builder::jobs, JsonpDeserializer.stringMapDeserializer(JobUsage._DESERIALIZER), "jobs");
        op.add(Builder::nodeCount, JsonpDeserializer.integerDeserializer(), "node_count");
        op.add(Builder::dataFrameAnalyticsJobs, MlDataFrameAnalyticsJobs._DESERIALIZER, "data_frame_analytics_jobs");
        op.add(Builder::inference, MlInference._DESERIALIZER, "inference");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<MachineLearning> {
        private Map<String, Datafeed> datafeeds;
        private Map<String, JobUsage> jobs;
        private Integer nodeCount;
        private MlDataFrameAnalyticsJobs dataFrameAnalyticsJobs;
        private MlInference inference;

        public Builder() {
        }

        private Builder(MachineLearning instance) {
            this.datafeeds = instance.datafeeds;
            this.jobs = instance.jobs;
            this.nodeCount = instance.nodeCount;
            this.dataFrameAnalyticsJobs = instance.dataFrameAnalyticsJobs;
            this.inference = instance.inference;
        }

        public final Builder datafeeds(Map<String, Datafeed> map) {
            this.datafeeds = Builder._mapPutAll(this.datafeeds, map);
            return this;
        }

        public final Builder datafeeds(String key, Datafeed value) {
            this.datafeeds = Builder._mapPut(this.datafeeds, key, value);
            return this;
        }

        public final Builder datafeeds(String key, Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.datafeeds(key, fn.apply(new Datafeed.Builder()).build());
        }

        public final Builder jobs(Map<String, JobUsage> map) {
            this.jobs = Builder._mapPutAll(this.jobs, map);
            return this;
        }

        public final Builder jobs(String key, JobUsage value) {
            this.jobs = Builder._mapPut(this.jobs, key, value);
            return this;
        }

        public final Builder jobs(String key, Function<JobUsage.Builder, ObjectBuilder<JobUsage>> fn) {
            return this.jobs(key, fn.apply(new JobUsage.Builder()).build());
        }

        public final Builder nodeCount(int value) {
            this.nodeCount = value;
            return this;
        }

        public final Builder dataFrameAnalyticsJobs(MlDataFrameAnalyticsJobs value) {
            this.dataFrameAnalyticsJobs = value;
            return this;
        }

        public final Builder dataFrameAnalyticsJobs(Function<MlDataFrameAnalyticsJobs.Builder, ObjectBuilder<MlDataFrameAnalyticsJobs>> fn) {
            return this.dataFrameAnalyticsJobs(fn.apply(new MlDataFrameAnalyticsJobs.Builder()).build());
        }

        public final Builder inference(MlInference value) {
            this.inference = value;
            return this;
        }

        public final Builder inference(Function<MlInference.Builder, ObjectBuilder<MlInference>> fn) {
            return this.inference(fn.apply(new MlInference.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MachineLearning build() {
            this._checkSingleUse();
            return new MachineLearning(this);
        }
    }
}

