/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.DataTierPhaseStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataTiers
extends Base {
    private final DataTierPhaseStatistics dataWarm;
    @Nullable
    private final DataTierPhaseStatistics dataFrozen;
    private final DataTierPhaseStatistics dataCold;
    private final DataTierPhaseStatistics dataContent;
    private final DataTierPhaseStatistics dataHot;
    public static final JsonpDeserializer<DataTiers> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataTiers::setupDataTiersDeserializer);

    private DataTiers(Builder builder) {
        super(builder);
        this.dataWarm = ApiTypeHelper.requireNonNull(builder.dataWarm, this, "dataWarm");
        this.dataFrozen = builder.dataFrozen;
        this.dataCold = ApiTypeHelper.requireNonNull(builder.dataCold, this, "dataCold");
        this.dataContent = ApiTypeHelper.requireNonNull(builder.dataContent, this, "dataContent");
        this.dataHot = ApiTypeHelper.requireNonNull(builder.dataHot, this, "dataHot");
    }

    public static DataTiers of(Function<Builder, ObjectBuilder<DataTiers>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DataTierPhaseStatistics dataWarm() {
        return this.dataWarm;
    }

    @Nullable
    public final DataTierPhaseStatistics dataFrozen() {
        return this.dataFrozen;
    }

    public final DataTierPhaseStatistics dataCold() {
        return this.dataCold;
    }

    public final DataTierPhaseStatistics dataContent() {
        return this.dataContent;
    }

    public final DataTierPhaseStatistics dataHot() {
        return this.dataHot;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("data_warm");
        this.dataWarm.serialize(generator, mapper);
        if (this.dataFrozen != null) {
            generator.writeKey("data_frozen");
            this.dataFrozen.serialize(generator, mapper);
        }
        generator.writeKey("data_cold");
        this.dataCold.serialize(generator, mapper);
        generator.writeKey("data_content");
        this.dataContent.serialize(generator, mapper);
        generator.writeKey("data_hot");
        this.dataHot.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataTiersDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::dataWarm, DataTierPhaseStatistics._DESERIALIZER, "data_warm");
        op.add(Builder::dataFrozen, DataTierPhaseStatistics._DESERIALIZER, "data_frozen");
        op.add(Builder::dataCold, DataTierPhaseStatistics._DESERIALIZER, "data_cold");
        op.add(Builder::dataContent, DataTierPhaseStatistics._DESERIALIZER, "data_content");
        op.add(Builder::dataHot, DataTierPhaseStatistics._DESERIALIZER, "data_hot");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<DataTiers> {
        private DataTierPhaseStatistics dataWarm;
        @Nullable
        private DataTierPhaseStatistics dataFrozen;
        private DataTierPhaseStatistics dataCold;
        private DataTierPhaseStatistics dataContent;
        private DataTierPhaseStatistics dataHot;

        public Builder() {
        }

        private Builder(DataTiers instance) {
            this.dataWarm = instance.dataWarm;
            this.dataFrozen = instance.dataFrozen;
            this.dataCold = instance.dataCold;
            this.dataContent = instance.dataContent;
            this.dataHot = instance.dataHot;
        }

        public final Builder dataWarm(DataTierPhaseStatistics value) {
            this.dataWarm = value;
            return this;
        }

        public final Builder dataWarm(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataWarm(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public final Builder dataFrozen(@Nullable DataTierPhaseStatistics value) {
            this.dataFrozen = value;
            return this;
        }

        public final Builder dataFrozen(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataFrozen(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public final Builder dataCold(DataTierPhaseStatistics value) {
            this.dataCold = value;
            return this;
        }

        public final Builder dataCold(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataCold(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public final Builder dataContent(DataTierPhaseStatistics value) {
            this.dataContent = value;
            return this;
        }

        public final Builder dataContent(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataContent(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public final Builder dataHot(DataTierPhaseStatistics value) {
            this.dataHot = value;
            return this;
        }

        public final Builder dataHot(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataHot(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataTiers build() {
            this._checkSingleUse();
            return new DataTiers(this);
        }
    }
}

