/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.FeatureToggle;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Audit
extends FeatureToggle {
    private final List<String> outputs;
    public static final JsonpDeserializer<Audit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Audit::setupAuditDeserializer);

    private Audit(Builder builder) {
        super(builder);
        this.outputs = ApiTypeHelper.unmodifiable(builder.outputs);
    }

    public static Audit of(Function<Builder, ObjectBuilder<Audit>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> outputs() {
        return this.outputs;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.outputs)) {
            generator.writeKey("outputs");
            generator.writeStartArray();
            for (String item0 : this.outputs) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAuditDeserializer(ObjectDeserializer<Builder> op) {
        FeatureToggle.setupFeatureToggleDeserializer(op);
        op.add(Builder::outputs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "outputs");
    }

    public static class Builder
    extends FeatureToggle.AbstractBuilder<Builder>
    implements ObjectBuilder<Audit> {
        @Nullable
        private List<String> outputs;

        public Builder() {
        }

        private Builder(Audit instance) {
            this.outputs = instance.outputs;
        }

        public final Builder outputs(List<String> list) {
            this.outputs = Builder._listAddAll(this.outputs, list);
            return this;
        }

        public final Builder outputs(String value, String ... values) {
            this.outputs = Builder._listAdd(this.outputs, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Audit build() {
            this._checkSingleUse();
            return new Audit(this);
        }
    }
}

