/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.watcher.UpdateSettingsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateSettingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String indexAutoExpandReplicas;
    @Nullable
    private final Integer indexNumberOfReplicas;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<UpdateSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateSettingsRequest::setupUpdateSettingsRequestDeserializer);
    public static final Endpoint<UpdateSettingsRequest, UpdateSettingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateSettingsRequest, UpdateSettingsResponse>("es/watcher.update_settings", request -> "PUT", request -> "/_watcher/settings", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateSettingsResponse._DESERIALIZER);

    private UpdateSettingsRequest(Builder builder) {
        this.indexAutoExpandReplicas = builder.indexAutoExpandReplicas;
        this.indexNumberOfReplicas = builder.indexNumberOfReplicas;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public static UpdateSettingsRequest of(Function<Builder, ObjectBuilder<UpdateSettingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String indexAutoExpandReplicas() {
        return this.indexAutoExpandReplicas;
    }

    @Nullable
    public final Integer indexNumberOfReplicas() {
        return this.indexNumberOfReplicas;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.indexAutoExpandReplicas != null) {
            generator.writeKey("index.auto_expand_replicas");
            generator.write(this.indexAutoExpandReplicas);
        }
        if (this.indexNumberOfReplicas != null) {
            generator.writeKey("index.number_of_replicas");
            generator.write(this.indexNumberOfReplicas.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateSettingsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexAutoExpandReplicas, JsonpDeserializer.stringDeserializer(), "index.auto_expand_replicas");
        op.add(Builder::indexNumberOfReplicas, JsonpDeserializer.integerDeserializer(), "index.number_of_replicas");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateSettingsRequest> {
        @Nullable
        private String indexAutoExpandReplicas;
        @Nullable
        private Integer indexNumberOfReplicas;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(UpdateSettingsRequest instance) {
            this.indexAutoExpandReplicas = instance.indexAutoExpandReplicas;
            this.indexNumberOfReplicas = instance.indexNumberOfReplicas;
            this.masterTimeout = instance.masterTimeout;
            this.timeout = instance.timeout;
        }

        public final Builder indexAutoExpandReplicas(@Nullable String value) {
            this.indexAutoExpandReplicas = value;
            return this;
        }

        public final Builder indexNumberOfReplicas(@Nullable Integer value) {
            this.indexNumberOfReplicas = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateSettingsRequest build() {
            this._checkSingleUse();
            return new UpdateSettingsRequest(this);
        }
    }
}

