/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackAttachmentField;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlackAttachment
implements JsonpSerializable {
    @Nullable
    private final String authorIcon;
    @Nullable
    private final String authorLink;
    private final String authorName;
    @Nullable
    private final String color;
    @Nullable
    private final String fallback;
    private final List<SlackAttachmentField> fields;
    @Nullable
    private final String footer;
    @Nullable
    private final String footerIcon;
    @Nullable
    private final String imageUrl;
    @Nullable
    private final String pretext;
    @Nullable
    private final String text;
    @Nullable
    private final String thumbUrl;
    private final String title;
    @Nullable
    private final String titleLink;
    @Nullable
    private final Long ts;
    public static final JsonpDeserializer<SlackAttachment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackAttachment::setupSlackAttachmentDeserializer);

    private SlackAttachment(Builder builder) {
        this.authorIcon = builder.authorIcon;
        this.authorLink = builder.authorLink;
        this.authorName = ApiTypeHelper.requireNonNull(builder.authorName, this, "authorName");
        this.color = builder.color;
        this.fallback = builder.fallback;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.footer = builder.footer;
        this.footerIcon = builder.footerIcon;
        this.imageUrl = builder.imageUrl;
        this.pretext = builder.pretext;
        this.text = builder.text;
        this.thumbUrl = builder.thumbUrl;
        this.title = ApiTypeHelper.requireNonNull(builder.title, this, "title");
        this.titleLink = builder.titleLink;
        this.ts = builder.ts;
    }

    public static SlackAttachment of(Function<Builder, ObjectBuilder<SlackAttachment>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String authorIcon() {
        return this.authorIcon;
    }

    @Nullable
    public final String authorLink() {
        return this.authorLink;
    }

    public final String authorName() {
        return this.authorName;
    }

    @Nullable
    public final String color() {
        return this.color;
    }

    @Nullable
    public final String fallback() {
        return this.fallback;
    }

    public final List<SlackAttachmentField> fields() {
        return this.fields;
    }

    @Nullable
    public final String footer() {
        return this.footer;
    }

    @Nullable
    public final String footerIcon() {
        return this.footerIcon;
    }

    @Nullable
    public final String imageUrl() {
        return this.imageUrl;
    }

    @Nullable
    public final String pretext() {
        return this.pretext;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Nullable
    public final String thumbUrl() {
        return this.thumbUrl;
    }

    public final String title() {
        return this.title;
    }

    @Nullable
    public final String titleLink() {
        return this.titleLink;
    }

    @Nullable
    public final Long ts() {
        return this.ts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.authorIcon != null) {
            generator.writeKey("author_icon");
            generator.write(this.authorIcon);
        }
        if (this.authorLink != null) {
            generator.writeKey("author_link");
            generator.write(this.authorLink);
        }
        generator.writeKey("author_name");
        generator.write(this.authorName);
        if (this.color != null) {
            generator.writeKey("color");
            generator.write(this.color);
        }
        if (this.fallback != null) {
            generator.writeKey("fallback");
            generator.write(this.fallback);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (SlackAttachmentField item0 : this.fields) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.footer != null) {
            generator.writeKey("footer");
            generator.write(this.footer);
        }
        if (this.footerIcon != null) {
            generator.writeKey("footer_icon");
            generator.write(this.footerIcon);
        }
        if (this.imageUrl != null) {
            generator.writeKey("image_url");
            generator.write(this.imageUrl);
        }
        if (this.pretext != null) {
            generator.writeKey("pretext");
            generator.write(this.pretext);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
        if (this.thumbUrl != null) {
            generator.writeKey("thumb_url");
            generator.write(this.thumbUrl);
        }
        generator.writeKey("title");
        generator.write(this.title);
        if (this.titleLink != null) {
            generator.writeKey("title_link");
            generator.write(this.titleLink);
        }
        if (this.ts != null) {
            generator.writeKey("ts");
            generator.write(this.ts.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSlackAttachmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::authorIcon, JsonpDeserializer.stringDeserializer(), "author_icon");
        op.add(Builder::authorLink, JsonpDeserializer.stringDeserializer(), "author_link");
        op.add(Builder::authorName, JsonpDeserializer.stringDeserializer(), "author_name");
        op.add(Builder::color, JsonpDeserializer.stringDeserializer(), "color");
        op.add(Builder::fallback, JsonpDeserializer.stringDeserializer(), "fallback");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(SlackAttachmentField._DESERIALIZER), "fields");
        op.add(Builder::footer, JsonpDeserializer.stringDeserializer(), "footer");
        op.add(Builder::footerIcon, JsonpDeserializer.stringDeserializer(), "footer_icon");
        op.add(Builder::imageUrl, JsonpDeserializer.stringDeserializer(), "image_url");
        op.add(Builder::pretext, JsonpDeserializer.stringDeserializer(), "pretext");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::thumbUrl, JsonpDeserializer.stringDeserializer(), "thumb_url");
        op.add(Builder::title, JsonpDeserializer.stringDeserializer(), "title");
        op.add(Builder::titleLink, JsonpDeserializer.stringDeserializer(), "title_link");
        op.add(Builder::ts, JsonpDeserializer.longDeserializer(), "ts");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlackAttachment> {
        @Nullable
        private String authorIcon;
        @Nullable
        private String authorLink;
        private String authorName;
        @Nullable
        private String color;
        @Nullable
        private String fallback;
        @Nullable
        private List<SlackAttachmentField> fields;
        @Nullable
        private String footer;
        @Nullable
        private String footerIcon;
        @Nullable
        private String imageUrl;
        @Nullable
        private String pretext;
        @Nullable
        private String text;
        @Nullable
        private String thumbUrl;
        private String title;
        @Nullable
        private String titleLink;
        @Nullable
        private Long ts;

        public Builder() {
        }

        private Builder(SlackAttachment instance) {
            this.authorIcon = instance.authorIcon;
            this.authorLink = instance.authorLink;
            this.authorName = instance.authorName;
            this.color = instance.color;
            this.fallback = instance.fallback;
            this.fields = instance.fields;
            this.footer = instance.footer;
            this.footerIcon = instance.footerIcon;
            this.imageUrl = instance.imageUrl;
            this.pretext = instance.pretext;
            this.text = instance.text;
            this.thumbUrl = instance.thumbUrl;
            this.title = instance.title;
            this.titleLink = instance.titleLink;
            this.ts = instance.ts;
        }

        public final Builder authorIcon(@Nullable String value) {
            this.authorIcon = value;
            return this;
        }

        public final Builder authorLink(@Nullable String value) {
            this.authorLink = value;
            return this;
        }

        public final Builder authorName(String value) {
            this.authorName = value;
            return this;
        }

        public final Builder color(@Nullable String value) {
            this.color = value;
            return this;
        }

        public final Builder fallback(@Nullable String value) {
            this.fallback = value;
            return this;
        }

        public final Builder fields(List<SlackAttachmentField> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(SlackAttachmentField value, SlackAttachmentField ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<SlackAttachmentField.Builder, ObjectBuilder<SlackAttachmentField>> fn) {
            return this.fields(fn.apply(new SlackAttachmentField.Builder()).build(), new SlackAttachmentField[0]);
        }

        public final Builder footer(@Nullable String value) {
            this.footer = value;
            return this;
        }

        public final Builder footerIcon(@Nullable String value) {
            this.footerIcon = value;
            return this;
        }

        public final Builder imageUrl(@Nullable String value) {
            this.imageUrl = value;
            return this;
        }

        public final Builder pretext(@Nullable String value) {
            this.pretext = value;
            return this;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        public final Builder thumbUrl(@Nullable String value) {
            this.thumbUrl = value;
            return this;
        }

        public final Builder title(String value) {
            this.title = value;
            return this;
        }

        public final Builder titleLink(@Nullable String value) {
            this.titleLink = value;
            return this;
        }

        public final Builder ts(@Nullable Long value) {
            this.ts = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlackAttachment build() {
            this._checkSingleUse();
            return new SlackAttachment(this);
        }
    }
}

