/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.watcher.EmailAttachment;
import co.elastic.clients.elasticsearch.watcher.EmailAttachmentVariant;
import co.elastic.clients.elasticsearch.watcher.HttpInputRequestDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ReportingEmailAttachment
implements EmailAttachmentVariant,
JsonpSerializable {
    private final String url;
    @Nullable
    private final Boolean inline;
    @Nullable
    private final Integer retries;
    @Nullable
    private final Time interval;
    @Nullable
    private final HttpInputRequestDefinition request;
    public static final JsonpDeserializer<ReportingEmailAttachment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReportingEmailAttachment::setupReportingEmailAttachmentDeserializer);

    private ReportingEmailAttachment(Builder builder) {
        this.url = ApiTypeHelper.requireNonNull(builder.url, this, "url");
        this.inline = builder.inline;
        this.retries = builder.retries;
        this.interval = builder.interval;
        this.request = builder.request;
    }

    public static ReportingEmailAttachment of(Function<Builder, ObjectBuilder<ReportingEmailAttachment>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public EmailAttachment.Kind _emailAttachmentKind() {
        return EmailAttachment.Kind.Reporting;
    }

    public final String url() {
        return this.url;
    }

    @Nullable
    public final Boolean inline() {
        return this.inline;
    }

    @Nullable
    public final Integer retries() {
        return this.retries;
    }

    @Nullable
    public final Time interval() {
        return this.interval;
    }

    @Nullable
    public final HttpInputRequestDefinition request() {
        return this.request;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("url");
        generator.write(this.url);
        if (this.inline != null) {
            generator.writeKey("inline");
            generator.write(this.inline.booleanValue());
        }
        if (this.retries != null) {
            generator.writeKey("retries");
            generator.write(this.retries.intValue());
        }
        if (this.interval != null) {
            generator.writeKey("interval");
            this.interval.serialize(generator, mapper);
        }
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupReportingEmailAttachmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
        op.add(Builder::inline, JsonpDeserializer.booleanDeserializer(), "inline");
        op.add(Builder::retries, JsonpDeserializer.integerDeserializer(), "retries");
        op.add(Builder::interval, Time._DESERIALIZER, "interval");
        op.add(Builder::request, HttpInputRequestDefinition._DESERIALIZER, "request");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ReportingEmailAttachment> {
        private String url;
        @Nullable
        private Boolean inline;
        @Nullable
        private Integer retries;
        @Nullable
        private Time interval;
        @Nullable
        private HttpInputRequestDefinition request;

        public Builder() {
        }

        private Builder(ReportingEmailAttachment instance) {
            this.url = instance.url;
            this.inline = instance.inline;
            this.retries = instance.retries;
            this.interval = instance.interval;
            this.request = instance.request;
        }

        public final Builder url(String value) {
            this.url = value;
            return this;
        }

        public final Builder inline(@Nullable Boolean value) {
            this.inline = value;
            return this;
        }

        public final Builder retries(@Nullable Integer value) {
            this.retries = value;
            return this;
        }

        public final Builder interval(@Nullable Time value) {
            this.interval = value;
            return this;
        }

        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        public final Builder request(@Nullable HttpInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<HttpInputRequestDefinition.Builder, ObjectBuilder<HttpInputRequestDefinition>> fn) {
            return this.request(fn.apply(new HttpInputRequestDefinition.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReportingEmailAttachment build() {
            this._checkSingleUse();
            return new ReportingEmailAttachment(this);
        }
    }
}

