/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetTransformStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Long from;
    @Nullable
    private final Long size;
    @Nullable
    private final Time timeout;
    private final List<String> transformId;
    public static final Endpoint<GetTransformStatsRequest, GetTransformStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTransformStatsRequest, GetTransformStatsResponse>("es/transform.get_transform_stats", request -> "GET", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("transformId", request.transformId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTransformStatsResponse._DESERIALIZER);

    private GetTransformStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.size = builder.size;
        this.timeout = builder.timeout;
        this.transformId = ApiTypeHelper.unmodifiableRequired(builder.transformId, (Object)this, "transformId");
    }

    public static GetTransformStatsRequest of(Function<Builder, ObjectBuilder<GetTransformStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Long from() {
        return this.from;
    }

    @Nullable
    public final Long size() {
        return this.size;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final List<String> transformId() {
        return this.transformId;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetTransformStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Long from;
        @Nullable
        private Long size;
        @Nullable
        private Time timeout;
        private List<String> transformId;

        public Builder() {
        }

        private Builder(GetTransformStatsRequest instance) {
            this.allowNoMatch = instance.allowNoMatch;
            this.from = instance.from;
            this.size = instance.size;
            this.timeout = instance.timeout;
            this.transformId = instance.transformId;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder from(@Nullable Long value) {
            this.from = value;
            return this;
        }

        public final Builder size(@Nullable Long value) {
            this.size = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder transformId(List<String> list) {
            this.transformId = Builder._listAddAll(this.transformId, list);
            return this;
        }

        public final Builder transformId(String value, String ... values) {
            this.transformId = Builder._listAdd(this.transformId, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTransformStatsRequest build() {
            this._checkSingleUse();
            return new GetTransformStatsRequest(this);
        }
    }
}

