/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.synonyms;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SynonymRule
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final String synonyms;
    public static final JsonpDeserializer<SynonymRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SynonymRule::setupSynonymRuleDeserializer);

    private SynonymRule(Builder builder) {
        this.id = builder.id;
        this.synonyms = ApiTypeHelper.requireNonNull(builder.synonyms, this, "synonyms");
    }

    public static SynonymRule of(Function<Builder, ObjectBuilder<SynonymRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final String synonyms() {
        return this.synonyms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("synonyms");
        generator.write(this.synonyms);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSynonymRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::synonyms, JsonpDeserializer.stringDeserializer(), "synonyms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SynonymRule> {
        @Nullable
        private String id;
        private String synonyms;

        public Builder() {
        }

        private Builder(SynonymRule instance) {
            this.id = instance.id;
            this.synonyms = instance.synonyms;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder synonyms(String value) {
            this.synonyms = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SynonymRule build() {
            this._checkSingleUse();
            return new SynonymRule(this);
        }
    }
}

